package gov.va.med.ewv.model.response;

import java.io.Serializable;

import gov.va.med.ewv.util.DTOBase;
import gov.va.med.ewv.util.EwvUtils;

public class CobAmountsBean extends DTOBase implements Serializable
{
    
    private static final long serialVersionUID                    = 3615915360571663352L;
    private String            ohiPayerId;
    private String             cobPatientResponsibility;
    private String             cobSubmittedCharges;
    private String             cobTotalAllowedAmount;
    private String             cobApprovedAmount;
    private String             cobTotalNonCoveredAmount;
    private String             cobPayerPaidAmount;
    private String             cobTotalDeniedAmount;
    private String             cobPatientPaidAmount;
    private String             cobTotalMedicarePaidAmount;
    private String             medicarePaidOneHundredPercentAmount;
    private String             medicarePaidEightyPercentAmount;
    private String             medicarePaidAmt;
    private String             cobMedicareATrustFund;
    private String             cobMedicareBTrustFund;
    
    public CobAmountsBean(String ohiPayerId, 
                          String cobSubmittedCharges, 
                          String cobTotalAllowedAmount, 
                          String cobApprovedAmount, 
                          String cobTotalNonCoveredAmount, 
                          String cobPayerPaidAmount, 
                          String cobTotalDeniedAmount, 
                          String cobPatientPaidAmount, 
                          String cobTotalMedicarePaidAmount, 
                          String medicarePaidOneHundredPercentAmount, 
                          String medicarePaidEightyPercentAmount, 
                          String cobPatientResponsibility, 
                          String medicarePaidAmt, 
                          String cobMedicareATrustFund, 
                          String cobMedicareBTrustFund)
    {
        this.ohiPayerId = ohiPayerId;
        this.cobSubmittedCharges = EwvUtils.formatAsCurrency(cobSubmittedCharges);
        this.cobTotalAllowedAmount = EwvUtils.formatAsCurrency(cobTotalAllowedAmount);
        this.cobApprovedAmount = EwvUtils.formatAsCurrency(cobApprovedAmount);
        this.cobTotalNonCoveredAmount = EwvUtils.formatAsCurrency(cobTotalNonCoveredAmount);
        this.cobPayerPaidAmount = EwvUtils.formatAsCurrency(cobPayerPaidAmount);
        this.cobTotalDeniedAmount = EwvUtils.formatAsCurrency(cobTotalDeniedAmount);
        this.cobPatientPaidAmount = EwvUtils.formatAsCurrency(cobPatientPaidAmount);
        this.cobTotalMedicarePaidAmount = EwvUtils.formatAsCurrency(cobTotalMedicarePaidAmount);
        this.medicarePaidOneHundredPercentAmount = EwvUtils.formatAsCurrency(medicarePaidOneHundredPercentAmount);
        this.medicarePaidEightyPercentAmount = EwvUtils.formatAsCurrency(medicarePaidEightyPercentAmount);
        this.cobPatientResponsibility = EwvUtils.formatAsCurrency(cobPatientResponsibility);
        this.medicarePaidAmt = EwvUtils.formatAsCurrency(medicarePaidAmt);
        this.cobMedicareATrustFund = EwvUtils.formatAsCurrency(cobMedicareATrustFund);
        this.cobMedicareBTrustFund = EwvUtils.formatAsCurrency(cobMedicareBTrustFund);
    }
    
    public String getOhiPayerId()
    {
        return ohiPayerId;
    }
    
    public void setOhiPayerId(String ohiPayerId)
    {
        this.ohiPayerId = ohiPayerId;
    }

    public String getCobPatientResponsibility() {
      return cobPatientResponsibility;
    }

    public void setCobPatientResponsibility(String cobPatientResponsibility) {
      this.cobPatientResponsibility = cobPatientResponsibility;
    }

    public String getCobSubmittedCharges() {
      return cobSubmittedCharges;
    }

    public void setCobSubmittedCharges(String cobSubmittedCharges) {
      this.cobSubmittedCharges = cobSubmittedCharges;
    }

    public String getCobTotalAllowedAmount() {
      return cobTotalAllowedAmount;
    }

    public void setCobTotalAllowedAmount(String cobTotalAllowedAmount) {
      this.cobTotalAllowedAmount = cobTotalAllowedAmount;
    }

    public String getCobApprovedAmount() {
      return cobApprovedAmount;
    }

    public void setCobApprovedAmount(String cobApprovedAmount) {
      this.cobApprovedAmount = cobApprovedAmount;
    }

    public String getCobTotalNonCoveredAmount() {
      return cobTotalNonCoveredAmount;
    }

    public void setCobTotalNonCoveredAmount(String cobTotalNonCoveredAmount) {
      this.cobTotalNonCoveredAmount = cobTotalNonCoveredAmount;
    }

    public String getCobPayerPaidAmount() {
      return cobPayerPaidAmount;
    }

    public void setCobPayerPaidAmount(String cobPayerPaidAmount) {
      this.cobPayerPaidAmount = cobPayerPaidAmount;
    }

    public String getCobTotalDeniedAmount() {
      return cobTotalDeniedAmount;
    }

    public void setCobTotalDeniedAmount(String cobTotalDeniedAmount) {
      this.cobTotalDeniedAmount = cobTotalDeniedAmount;
    }

    public String getCobPatientPaidAmount() {
      return cobPatientPaidAmount;
    }

    public void setCobPatientPaidAmount(String cobPatientPaidAmount) {
      this.cobPatientPaidAmount = cobPatientPaidAmount;
    }

    public String getCobTotalMedicarePaidAmount() {
      return cobTotalMedicarePaidAmount;
    }

    public void setCobTotalMedicarePaidAmount(String cobTotalMedicarePaidAmount) {
      this.cobTotalMedicarePaidAmount = cobTotalMedicarePaidAmount;
    }

    public String getMedicarePaidOneHundredPercentAmount() {
      return medicarePaidOneHundredPercentAmount;
    }

    public void setMedicarePaidOneHundredPercentAmount(String medicarePaidOneHundredPercentAmount) {
      this.medicarePaidOneHundredPercentAmount = medicarePaidOneHundredPercentAmount;
    }

    public String getMedicarePaidEightyPercentAmount() {
      return medicarePaidEightyPercentAmount;
    }

    public void setMedicarePaidEightyPercentAmount(String medicarePaidEightyPercentAmount) {
      this.medicarePaidEightyPercentAmount = medicarePaidEightyPercentAmount;
    }

    public String getMedicarePaidAmt() {
      return medicarePaidAmt;
    }

    public void setMedicarePaidAmt(String medicarePaidAmt) {
      this.medicarePaidAmt = medicarePaidAmt;
    }

    public String getCobMedicareATrustFund() {
      return cobMedicareATrustFund;
    }

    public void setCobMedicareATrustFund(String cobMedicareATrustFund) {
      this.cobMedicareATrustFund = cobMedicareATrustFund;
    }

    public String getCobMedicareBTrustFund() {
      return cobMedicareBTrustFund;
    }

    public void setCobMedicareBTrustFund(String cobMedicareBTrustFund) {
      this.cobMedicareBTrustFund = cobMedicareBTrustFund;
    }
    
    public boolean getShouldRender()
    {
      boolean ok = EwvUtils.okToRender(cobSubmittedCharges, 
                                        cobTotalAllowedAmount, 
                                        cobApprovedAmount, 
                                        cobTotalNonCoveredAmount, 
                                        cobPayerPaidAmount, 
                                        cobTotalDeniedAmount, 
                                        cobPatientPaidAmount, 
                                        cobTotalMedicarePaidAmount, 
                                        medicarePaidEightyPercentAmount, 
                                        medicarePaidOneHundredPercentAmount, 
                                        cobPatientResponsibility, 
                                        medicarePaidAmt, 
                                        cobMedicareATrustFund, 
                                        cobMedicareBTrustFund);

      return ok;
    }
    
}
