package gov.va.med.ewv.model.response;


import java.io.Serializable;

import gov.va.med.ewv.util.AdjustmentType;
import gov.va.med.ewv.util.EwvUtils;

public class ClaimOhiAdjustment extends Adjustment implements Serializable
{
    private static final long serialVersionUID = 3822039878303611586L;
    private String reasonCode;
    private String descriptionLong;
    private String descriptionShort;
    private String quantity;
    private String  coAmount;
    private String  crAmount;
    private String  oaAmount;
    private String  piAmount;
    private String  prAmount;
    
    private AdjustmentType adjustmentType;
//    private String primaryPayerId;  
    
    public ClaimOhiAdjustment(String primaryPayerId,
    		                  String claimAdjustmentReasonCode,
    		                  String descriptionLong,
    		                  String descriptionShort,
    		                  String quantity,
    		                  String coAmount,
    		                  String crAmount,
    		                  String oaAmount,
    		                  String piAmount,
    		                  String prAmount)
    {
        this.reasonCode = claimAdjustmentReasonCode;
        this.descriptionLong = descriptionLong;
        this.descriptionShort = descriptionShort;
        //this.quantity = EwvUtils.formatAsInteger(quantity);
        this.quantity = quantity;
        this.coAmount = EwvUtils.formatAsCurrency(coAmount);
        this.crAmount = EwvUtils.formatAsCurrency(crAmount);
        this.oaAmount = EwvUtils.formatAsCurrency(oaAmount);
        this.piAmount = EwvUtils.formatAsCurrency(piAmount);
        this.prAmount = EwvUtils.formatAsCurrency(prAmount);
        
//        this.primaryPayerId = primaryPayerId;
    }
    
    public String getReasonCode()
    {
        return reasonCode;
    }
    
    public void setReasonCode(String claimAdjustmentReasonCode)
    {
        this.reasonCode = claimAdjustmentReasonCode;
    }
    
    public String getDescriptionLong()
    {
        return descriptionLong;
    }
    
    public void setDescriptionLong(String descriptionLong)
    {
        this.descriptionLong = descriptionLong;
    }
    
    public String getDescriptionShort()
    {
        return descriptionShort;
    }
    
    public void setDescriptionShort(String descriptionShort)
    {
        this.descriptionShort = descriptionShort;
    }
    
    public AdjustmentType getAdjustmentType()
    {
        return adjustmentType;
    }

    public void setAdjustmentType(AdjustmentType adjustmentType)
    {
        this.adjustmentType = adjustmentType;
    }

//    public String getPrimaryPayerId()
//    {
//        return primaryPayerId;
//    }
//
//    @Override
//    public void setPrimaryPayerId(String primaryPayerId)
//    {
//        this.primaryPayerId = primaryPayerId;
//    }

    public String getQuantity()
    {
        return quantity;
    }
    
    @Override
    public void setQuantity(String quantity)
    {
        this.quantity = quantity;
    }

    public String getCoAmount() {
      return coAmount;
    }

    public void setCoAmount(String coAmount) {
      this.coAmount = coAmount;
    }
    
    public String getCrAmount() {
      return crAmount;
    }

    public void setCrAmount(String crAmount) {
      this.crAmount = crAmount;
    }

    public String getOaAmount() {
      return oaAmount;
    }

    public void setOaAmount(String oaAmount) {
      this.oaAmount = oaAmount;
    }

    public String getPiAmount() {
      return piAmount;
    }

    public void setPiAmount(String piAmount) {
      this.piAmount = piAmount;
    }

    public String getPrAmount() {
      return prAmount;
    }

    public void setPrAmount(String prAmount) {
      this.prAmount = prAmount;
    }
    
}
