package gov.va.med.ewv.model.response;

import java.util.List;

import gov.va.med.ewv.codes.RemittanceCode;
import gov.va.med.ewv.util.DTOBase;
import gov.va.med.ewv.util.EwvUtils;


public class ClaimOhi extends DTOBase
{
    private String otherPayerShortName;
    private String otherPayerName;
    private boolean useOtherPayerModalPanel = false;
    private String ohiGroupName;
    private String ohiPayerId;
    private String ohiPayerShortId;
    private String payerPaidAmount;
	private List<ClaimOhiAdjustment> claimOhiAdjustments;
	private List<RemittanceCode> remittanceRemarkCodes;
    
	public ClaimOhi() {
	}
	
	public ClaimOhi(String otherPayerName,
    		               String ohiGroupName,
    		               String ohiPayerId,
    		               String payerPaidAmount,
    		               List<ClaimOhiAdjustment> claimOhiAdjustments,
    		               List<RemittanceCode> remittanceRemarkCodes)
    {
        setOtherPayerName(otherPayerName);
        setOhiPayerId(ohiPayerId);
        this.ohiGroupName = ohiGroupName;
        this.payerPaidAmount = EwvUtils.formatAsCurrency(payerPaidAmount);
        this.setClaimOhiAdjustments(claimOhiAdjustments);
        this.remittanceRemarkCodes = remittanceRemarkCodes;
    }
    
	public void setOtherPayerName(String otherPayerName) {
		this.otherPayerName = otherPayerName;
		this.otherPayerShortName = EwvUtils.shorten(otherPayerName, 15);
		setUseOtherPayerModalPanel(otherPayerShortName.endsWith("..."));
	}

	public String getOtherPayerName() {
		return otherPayerName;
	}

	public void setOhiGroupName(String ohiGroupName) {
		this.ohiGroupName = ohiGroupName;
	}

	public String getOhiGroupName() {
		return ohiGroupName;
	}

	public void setOhiPayerId(String ohiPayerId) {
		this.ohiPayerId = ohiPayerId;
		this.ohiPayerShortId = EwvUtils.shorten(ohiPayerId, 15);
		setUseOtherPayerModalPanel(ohiPayerShortId.endsWith("..."));
	}

	public String getOhiPayerId() {
		return ohiPayerId;
	}
	
	public void setOhiPayerShortId(String ohiPayerShortId) {
		this.ohiPayerShortId = ohiPayerShortId;
	}

	public String getOhiPayerShortId() {
		return ohiPayerShortId;
	}

	public void setPayerPaidAmount(String payerPaidAmount) {
		this.payerPaidAmount = payerPaidAmount;
	}

	public String getPayerPaidAmount() {
		return payerPaidAmount;
	}

	public void setClaimOhiAdjustments(List<ClaimOhiAdjustment> claimOhiAdjustments) {
		this.claimOhiAdjustments = claimOhiAdjustments;
	}

	public List<ClaimOhiAdjustment> getClaimOhiAdjustments() {
		return claimOhiAdjustments;
	}
    
	public void setRemittanceRemarkCodes(List<RemittanceCode> remittanceRemarkCodes) {
		this.remittanceRemarkCodes = remittanceRemarkCodes;
	}

	public List<RemittanceCode> getRemittanceRemarkCodes() {
		return remittanceRemarkCodes;
	}

  public void setOtherPayerShortName(String otherPayerShortName) {
    this.otherPayerShortName = otherPayerShortName;
  }

  public String getOtherPayerShortName() {
    return otherPayerShortName;
  }

  public void setUseOtherPayerModalPanel(boolean useOtherPayerModalPanel) {
    this.useOtherPayerModalPanel = useOtherPayerModalPanel;
  }

  public boolean getUseOtherPayerModalPanel() {
    return useOtherPayerModalPanel;
  }
}
