	package gov.va.med.ewv.controller;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RestController;

import gov.va.med.ars.exceptions.GenericException;
import gov.va.med.ewv.model.response.OhiInfoContainer;
import gov.va.med.ewv.service.IEwvOhiService;

@RestController
public class EwvClaimOhiInfoController {

	private static final Logger logger = LogManager.getLogger(EwvClaimOhiInfoController.class);
	
	@Autowired
	private IEwvOhiService ewvOhiService;
	
	@GetMapping(value = "api/v1/ewvClaim/ohi/{pdiNumber}")
    public ResponseEntity<?> getDetail(@PathVariable("pdiNumber") String pdiNumber) throws GenericException {
		
		logger.info("Invoked the controller to retrieve the claim details for pdiNumber :"+pdiNumber);
		OhiInfoContainer ewvClaim = ewvOhiService.getOhiData(pdiNumber);
		
		return ResponseEntity.ok().body(ewvClaim);
    }
}
