package gov.va.med.ewv.controller;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RestController;

import gov.va.med.ars.exceptions.GenericException;
import gov.va.med.ewv.model.response.EwvClaimDetailResponse;
import gov.va.med.ewv.service.IEwvClaimService;

@RestController
public class EwvClaimController {

	private static final Logger logger = LogManager.getLogger(EwvClaimController.class);
	
	@Autowired
	private IEwvClaimService ewvClaimService;
	
	@GetMapping(value = "api/v1/ewvClaim/{pdiNumber}")
    public ResponseEntity<?> getDetail(@PathVariable("pdiNumber") String pdiNumber) throws GenericException {
		
		logger.info("Invoked the controller to retrieve the claim details for pdiNumber :"+pdiNumber);
		EwvClaimDetailResponse ewvClaim = ewvClaimService.getEwvClaim(pdiNumber);
		
		return ResponseEntity.ok().body(ewvClaim);
    }
}
