package gov.va.med.ewv.codes;


import java.io.Serializable;
import java.util.List;

import com.fasterxml.jackson.annotation.JsonIgnore;

public class ProcedureCodesContainer implements Serializable
{
	
    private static final long serialVersionUID = -5729926584399303196L;
    
    private String              principalProcedure;
    private String              dateOfPrincipalProcedure;
    
    // For Phase II, there is no need to use four columns
    private List<ProcedureCode> procedureCodes = null;

    public ProcedureCodesContainer(String principalProcedure,
    		                       String dateOfPrincipalProcedure,
    		                       List<ProcedureCode> procedureCodes)
    {
        this.principalProcedure = principalProcedure;
        this.dateOfPrincipalProcedure = dateOfPrincipalProcedure;
        this.procedureCodes = procedureCodes;
        
    }
    
    public String getPrincipalProcedure()
    {
        return principalProcedure;
    }
    
    public void setPrincipalProcedure(String principalProcedure)
    {
        this.principalProcedure = principalProcedure;
    }
    
    public String getDateOfPrincipalProcedure()
    {
        return dateOfPrincipalProcedure;
    }
    
    public void setDateOfPrincipalProcedure(String dateOfPrincipalProcedure)
    {
        this.dateOfPrincipalProcedure = dateOfPrincipalProcedure;
    }
    
    public List<ProcedureCode> getProcedureCodes()
    {
        return procedureCodes;
    }
    
    public void setProcedureCodes(List<ProcedureCode> procedureCodes)
    {
        this.procedureCodes = procedureCodes;
    }
    
    @JsonIgnore
    public boolean getShouldOtherProcCodesRender()
    {
      boolean returnVal = false;
      
      if (procedureCodes != null && procedureCodes.size() > 1) {
        returnVal = true;
      }
      
      return returnVal;
    }
}
