package gov.va.med.ewv.codes;

import java.io.Serializable;

import gov.va.med.ewv.util.EwvUtils;

public class ProcedureCode extends CodeBase implements Serializable
{
    private static final long serialVersionUID = -5729926584399303196L;
    
    private String dateOfProcedure    = null;
    
    public ProcedureCode(Long procNumber, String procCode, String dateOfProcedure)
    {
        super(procNumber, procCode);
        this.dateOfProcedure = EwvUtils.formatAsDate(dateOfProcedure);
    }
    
    public String getDateOfProcedure()
    {
        return dateOfProcedure;
    }
    
    public void setDateOfProcedure(String dateOfProcedure)
    {
        this.dateOfProcedure = dateOfProcedure;
    }

}
