package gov.va.med.ewv.codes;

import java.io.Serializable;

public class ECode extends CodeBase implements Serializable
{
    private static final long serialVersionUID = 1748134964415856234L;
    
    private String            poaIndicator_5010;
    
    public ECode(Long sequence, String value, String poaIndicator_5010)
    {
        super(sequence, value);
        this.poaIndicator_5010 = poaIndicator_5010;
    }

    public String getValueWithPoa() {
      String retValue = value;
      if (poaIndicator_5010 != null && poaIndicator_5010.length() > 0) {
        retValue += " -" + poaIndicator_5010;
      }
      
      return retValue;
    }
  
    public String getPoaIndicator_5010() {
      return poaIndicator_5010;
    }

    public void setPoaIndicator_5010(String poaIndicator_5010) {
      this.poaIndicator_5010 = poaIndicator_5010;
    }

}
