package gov.va.med.ars.validators;

import java.util.InputMismatchException;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.http.HttpStatus;

import gov.va.med.ars.constants.ErrorMessages;
import gov.va.med.ars.exceptions.GenericException;

/**
 * @author Vamsi Krishna Gangarapu
 *
 */
abstract public class NumberValidator {

	private static final Logger logger = LogManager.getLogger(NumberValidator.class);

	/**
	 * @param numberToValid
	 * @return boolean value
	 * @throws GenericException
	 */
	public Boolean isValidNumber(String numberToValid) throws GenericException {
		Boolean isValid = false;
		try {
			if (numberToValid != null && numberToValid.matches("[0-9]+")) {
				//claimNumber = Long.valueOf(claimIndex).longValue();
				isValid = true;
				return isValid;
			} else {
				throw new GenericException(ErrorMessages.BAD_REQUEST, "Not a valid Number", HttpStatus.BAD_REQUEST);
			}

		} catch (InputMismatchException  e) {
			logger.error("NumberValidator.isValidNumber() internal_server_error for " + numberToValid
					+ " " + e);
			throw new GenericException(ErrorMessages.BAD_REQUEST, e.getMessage(), HttpStatus.BAD_REQUEST);
		}
	}

}
