package gov.va.med.ars.service.impl;

import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import gov.va.med.ars.dao.ars.ArsRoleRepository;
import gov.va.med.ars.dao.ars.ArsUserRoleUsagesRepository;
import gov.va.med.ars.dao.ars.IArsUserRepository;
import gov.va.med.ars.exceptions.GenericException;
import gov.va.med.ars.model.request.UserSearchRequest;
import gov.va.med.ars.service.IUserAdminService;
import gov.va.med.domain.ars.ArsRole;
import gov.va.med.domain.ars.ArsUser;
import gov.va.med.domain.ars.ArsUserRoleUsages;
import gov.va.med.domain.ars.ArsUserRoleUsagesId;
import javafx.util.Pair;

@Service
public class UserAdminServiceImpl implements IUserAdminService {
	
	private static final Logger logger = LogManager.getLogger(UserAdminServiceImpl.class);
	
	public static final String BASE_USER = "BASE_USER";
	public static final String ADMIN_USER = "ADMIN";
	
	
	@Autowired
	IArsUserRepository arsUserRepo;
	
	@Autowired
	ArsRoleRepository roleRepo;
	
	@Autowired
	ArsUserRoleUsagesRepository roleUsagesRepo;
	
	@SuppressWarnings("restriction")
	@Override
	public Pair <String,Boolean> createUser(UserSearchRequest request) throws GenericException {	
		
		ArsRole arsRoleAdmin = null;
		ArsRole arsRoleBase = null;

		long roleIdAdmin = 0;
		long roleIdBase = 0;
		
		boolean isAdmin = false;
		if(request.getAdmin() != null && !request.getAdmin().isEmpty() && request.getAdmin().equalsIgnoreCase("y")) {
			isAdmin = true;
		} else if (request.getAdmin() != null && !request.getAdmin().isEmpty() && request.getAdmin().equalsIgnoreCase("n")) { 
			isAdmin = false;
		} else{
			logger.info("Admin permissions not determined");
			return new Pair <>("Error in creating user",false);			
		}
		
		arsRoleAdmin = roleRepo.findOneByRoleName(ADMIN_USER);			
		arsRoleBase = roleRepo.findOneByRoleName(BASE_USER);
		
		if (arsRoleAdmin != null) {
			roleIdAdmin = arsRoleAdmin.getArsRoleId();
			
		} else {

			logger.info("Admin Role not available in ROLES Table");
			return new Pair <>("Error in creating user",false);
		}
		
		if (arsRoleAdmin != null) {
			roleIdBase = arsRoleBase.getArsRoleId();
			
		} else {

			logger.info("Base Role not available in ROLES Table");
			return new Pair <>("Error in creating user",false);
		}
		
		ArsUser arsUser = new ArsUser();
		arsUser.setUserName(request.getUserName());
		arsUser.setLastName(request.getLastName());
		arsUser.setFirstName(request.getFirstName());
		arsUser.setPhoneNumber(request.getPhone());
		arsUser.setEmailAddress(request.getEmail());		
		arsUser.setDateCreated(new Date());
		arsUser.setDomain(request.getDomain());
		if(request.getCreatedBy() != null && !request.getCreatedBy().isEmpty()) 
			arsUser.setCreatedBy(request.getCreatedBy());
		else{

			logger.info("Created by parameter is not available");
			return new Pair <>("Error in creating user",false);
		}
		
		if(request.getStatus()!=null&&!request.getStatus().isEmpty()){
			arsUser.setEnabled(request.getStatus());
		}else{

			logger.info("Status parameter is not available");
			return new Pair <>("Error in creating user",false);
		}
			
		arsUser.setEnableAdmin(isAdmin);
		
		boolean canEdit = false;
		if(request.getEdit() != null && !request.getEdit().isEmpty() && request.getEdit().equalsIgnoreCase("y")) {
			canEdit = true;
		} else if (request.getEdit() != null && !request.getEdit().isEmpty() && request.getEdit().equalsIgnoreCase("n")) { 
			canEdit = false;
		} else {

			logger.info("Edit Permission is not available");
			return new Pair <>("An error occurred during user creation.",false);
		}		
		arsUser.setEnableEdit(canEdit);
		
		boolean canExport = false;
		if(request.getExport() != null && !request.getExport().isEmpty() && request.getExport().equalsIgnoreCase("y")) {
			canExport = true;
		} else if (request.getExport() != null && !request.getExport().isEmpty() && request.getExport().equalsIgnoreCase("n")) { 
			canExport = false;
		} else {
			
			logger.info("Export Permission is not available");
			return new Pair <>("An error occurred during user creation.",false);
		}		
		arsUser.setEnableExport(canExport);

		ArsUser result = null;
		try {
			if(arsUserRepo.findByUserNameIgnoreCase(arsUser.getUserName())!=null){
				logger.info("User already present " + arsUser.getUserName());

				return new Pair <>("Username already exists",false);
			}
			result = arsUserRepo.save(arsUser);

		} catch (Exception e) {
			logger.error("createUser: User creation failed for userName: " + request.getUserName());
			throw e;
		}

		if (result != null && request.getAdmin() != null && !request.getAdmin().isEmpty() && request.getAdmin().equalsIgnoreCase("Y")) {	
			try {
				saveUserRole(result, roleIdAdmin, request.getCreatedBy());
				saveUserRole(result, roleIdBase, request.getCreatedBy());
			} catch (Exception e) {
				logger.error("createUser: ArsUserRoleUsages creation failed for userId: " + result.getArsUserId());
				throw e;
			}
		} else if (result != null && request.getAdmin() != null && !request.getAdmin().isEmpty() && request.getAdmin().equalsIgnoreCase("N")) {
			try {
				saveUserRole(result, roleIdBase, request.getCreatedBy());
			} catch (Exception e) {
				logger.error("createUser: ArsUserRoleUsages creation failed for userId: " + result.getArsUserId());
				throw e;
			}
		} else {

			return new Pair <>("An error occurred during user creation.",false);
		}
		logger.info("User was successfully created.");
		return new Pair <>("User was successfully created.",true);
	}
	
	private boolean saveUserRole(ArsUser arsUser, long roleId, String createdBy) {
		
		boolean roleSave = false;
		if (arsUser != null) {
			ArsUserRoleUsagesId id = new ArsUserRoleUsagesId();
			id.setArsRoleId(roleId);
			id.setArsUserId(arsUser.getArsUserId());
			Set<ArsUserRoleUsages> roleUsegeSet = new HashSet<ArsUserRoleUsages>();
			ArsUserRoleUsages roleUsage = new ArsUserRoleUsages();
			roleUsage.setDateCreated(new Date());
			roleUsage.setCreatedBy(createdBy);
			roleUsage.setId(id);
			roleUsegeSet.add(roleUsage);

			try {
				roleUsagesRepo.save(roleUsegeSet);
				roleSave =  true;
			} catch (Exception e) {
				logger.error("createUser: ArsUserRoleUsages creation failed for userId: " + arsUser.getArsUserId());
				throw e;
			}
		}
		return roleSave;
	}
}