package gov.va.med.ars.service.impl;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import gov.va.med.ars.dao.ars.ClaimSubmissionNoteRepository;
import gov.va.med.ars.dao.ars.ClaimSubmissionRepository;
import gov.va.med.ars.exceptions.EntityNotFoundException;
import gov.va.med.ars.model.request.UpdateRfaiRequest;
import gov.va.med.ars.service.IUpdateRfaiService;
import gov.va.med.domain.ars.ClaimSubmission;
import gov.va.med.domain.ars.ClaimSubmissionNote;

/**
 * @author PII
 *
 */
@Service
public class UpdateRfaiServiceImpl implements IUpdateRfaiService {

	private static final Logger logger = LogManager.getLogger(UpdateRfaiServiceImpl.class);

	DateFormat dateFormat = new SimpleDateFormat("MM/dd/yyyy");

	@Autowired
	ClaimSubmissionRepository rfaiRepo;

	@Autowired
	ClaimSubmissionNoteRepository claimSubmissionNoteRepo;

	public boolean submitSimpleUpdate(UpdateRfaiRequest updateRfaiRequest) throws ParseException, EntityNotFoundException {

		String oldStatus = null;

		ClaimSubmissionNote submittedNote = null;

		try {

			Date operationTime = new Date(System.currentTimeMillis());

			ClaimSubmission claimSubmissionBeingUpdated = rfaiRepo.findOne(updateRfaiRequest.getSubmissionId());
			if (claimSubmissionBeingUpdated == null) {
				throw new EntityNotFoundException(String.valueOf(updateRfaiRequest.getSubmissionId()));
			}

			oldStatus = claimSubmissionBeingUpdated.getSubmissionStatus();

			claimSubmissionBeingUpdated.setDtp203responseduedate(dateFormat.parse(updateRfaiRequest.getResponseDate()));
			claimSubmissionBeingUpdated.setSubmissionStatus(updateRfaiRequest.getSubmissionStatus());
			claimSubmissionBeingUpdated.setDatemodified(operationTime);

			rfaiRepo.save(claimSubmissionBeingUpdated);

			ClaimSubmissionNote newClaimSubmissionNote = new ClaimSubmissionNote();

			newClaimSubmissionNote.setClaimSubmission(claimSubmissionBeingUpdated);
			newClaimSubmissionNote.setClaimSubmissionNoteTxt(updateRfaiRequest.getSubmissionNote());
			newClaimSubmissionNote.setClaimsSubmissionOldStatus(oldStatus);
			newClaimSubmissionNote.setClaimsSubmissionNewStatus(claimSubmissionBeingUpdated.getSubmissionStatus());
			newClaimSubmissionNote.setDatecreated(operationTime);

			submittedNote = claimSubmissionNoteRepo.save(newClaimSubmissionNote);

		} catch (ParseException e) {
			logger.info(String.format("Couldn't parse date %s into MM/dd/yyyy format",
					updateRfaiRequest.getResponseDate()));
			logger.warn(e.getMessage(), e);
			throw e;
		} catch (EntityNotFoundException e) {
			logger.info(String.format("Error attempting to lookup claim with CLAIM_SUBMISSION.SUBMISSIONID of %s",
					updateRfaiRequest.getSubmissionId()));
			logger.warn(e.getMessage(), e);
			throw e;
		} 

		return submittedNote != null && submittedNote.getClaimSubmissionNoteId() != null;
	}

}
