package gov.va.med.ars.service.impl;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;

import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Service;

import gov.va.med.ars.constants.ErrorMessages;
import gov.va.med.ars.dao.ars.EreposdataRepository;
import gov.va.med.ars.dao.ars.IArsReportTypeRepository;
import gov.va.med.ars.dao.ars.IEreposClaimRepository;
import gov.va.med.ars.dao.ars.IReferenceIdentificationRepository;
import gov.va.med.ars.dao.ars.ITraceNumberRepository;
import gov.va.med.ars.dao.ars.TransactionsRepository;
import gov.va.med.ars.dao.erepos.IRfaiEreposRepository;
import gov.va.med.ars.dao.ewv.IEwvClaimAttachmentRepository;
import gov.va.med.ars.dao.ewv.IRfaiEwvRepository;
import gov.va.med.ars.dao.fpps.IFppsClaimAttachmentsRepository;
import gov.va.med.ars.dao.fpps.IRfaiFppsClaimRepository;
import gov.va.med.ars.exceptions.EntityNotFoundException;
import gov.va.med.ars.exceptions.GenericException;
import gov.va.med.ars.exceptions.ValidationException;
import gov.va.med.ars.model.request.Unmatched837Request;
import gov.va.med.ars.service.IUnmatched837AttachmentService;
import gov.va.med.ars.util.IEreposDataOnly;
import gov.va.med.domain.ars.Ereposdata;
import gov.va.med.domain.ars.TraceNumber;
import gov.va.med.domain.ars.Transactions;
import gov.va.med.domain.ewv.EwvClaims;
import gov.va.med.domain.ewv.EwvClaimsAttachment;
import gov.va.med.domain.ewv.EwvClaimsAttachmentId;
import gov.va.med.domain.fee.Claim;
import gov.va.med.domain.fee.ClaimAttachments;
import gov.va.med.domain.fee.ClaimAttachmentsId;
import gov.va.med.domain.fee.PersonInfo;

@Service
public class Unmatched837AttachmentServiceImpl implements IUnmatched837AttachmentService {

	private static final Logger logger = LogManager.getLogger(Unmatched837AttachmentServiceImpl.class);
	private DateFormat dateFormat = new SimpleDateFormat("MM/dd/yyyy");

	@Autowired
	IRfaiEwvRepository ewvRepository;

	@Autowired
	ITraceNumberRepository traceNumberRepository;

	@Autowired
	IArsReportTypeRepository arsReportTypeRepository;

	@Autowired
	IEwvClaimAttachmentRepository ewvClaimAttachmentRepository;

	@Autowired
	IRfaiEreposRepository ereposRepository;

	@Autowired
	IRfaiFppsClaimRepository fppsRepository;

	@Autowired
	TransactionsRepository transactionsRepository;

	@Autowired
	EreposdataRepository ereposDataRepository;

	@Autowired
	IEreposClaimRepository ereposClaimRepository;

	@Autowired
	IReferenceIdentificationRepository refIdRepository;

	@Autowired
	IFppsClaimAttachmentsRepository fppsClaimAttachmentsRepository;

	@Override
	public Boolean matchClaimAttachment(Unmatched837Request request)
			throws ValidationException, GenericException, EntityNotFoundException {

		Boolean unmatchedResponse = false;

		EwvClaims ewvClaim = new EwvClaims();
		Claim fppsClaim = new Claim();
		String idToMatch = request.getUnmatched837Id();
		String attachmentId = request.getAttachmentId();
		Ereposdata ereposData = new Ereposdata();
		try {
			if (idToMatch.length() <= 15) {

				if (idToMatch.length() == 15) {
					logger.info("idToMatch is  " + idToMatch + ", inside EWV section, line 89");
					// ewv
					if (Integer.valueOf(idToMatch.substring(4, 7)) <= 366
							&& checkclaimType(idToMatch.substring(7, 9))) {

						logger.info("calling ewvRepository to see if I can get a non-null ewvClaim");
						int pdiExists = ewvRepository.existsByPDI(idToMatch);

						if (pdiExists == 1) {
							logger.info("ewvClaim is not null, calling ewvRepo to get EdiClaimKey");
							// get Claim key from EWV
							ewvClaim = ewvRepository.getEwvPdiInfo(idToMatch);
							String ediClaimKey = ewvClaim.getEdiClaimKey().trim();
							logger.info("EdiClaimKey is " + ediClaimKey);

							logger.info("calling ereposRepository to get ClaimKey, and ReportCode");

							List<IEreposDataOnly> ereposDataObject = ereposClaimRepository
									.findClaimByClaimKey(ediClaimKey);
							if ((!ereposDataObject.isEmpty()) && ereposDataObject != null) {
								logger.info(ereposDataObject.get(0).getClaimkey1());
								/*
								 * for (IEreposDataOnly value : ereposDataObject) {
								 * logger.info(value.getClaimKey1()); logger.info(value.getReport()); }
								 */
								ereposData.setClaimKey(ereposDataObject.get(0).getClaimkey1());
								ereposData.setReportcode(ereposDataObject.get(0).getReport());

								logger.info("claimKey is " + ereposData.getClaimKey());
								logger.info("reportCode is " + ereposData.getReportcode());

								ereposData.setAttachmentId(Integer.valueOf(attachmentId));
								ereposData.setPayerclaimcontrolnumber("");
								ereposData.setExternalclaimid(idToMatch);

								// compare claim_key from EREPOS with claim_key from
								// EWV
								boolean isEwvKeySameAsEreposKey = (ediClaimKey.equals(ereposData.getClaimKey()));
								logger.info("confirming ewv's ediClaimKey is same as erepos' ediClaimKey "
										+ isEwvKeySameAsEreposKey);
								if (isEwvKeySameAsEreposKey) {

									// get receiverId from EREPOS Claim table
									String receiverId = ereposRepository
											.getReceiverIdByClaimKey(ereposData.getClaimKey());

									if (StringUtils.isNotBlank(receiverId)
											&& (!receiverId.contains("12115") || !receiverId.contains("12116"))) {

										saveEwvDataToTransactions(attachmentId, ewvClaim, ereposData);

										String reportCodeDescription = arsReportTypeRepository
												.getReportCodeDescriptionByReportCode(ereposData.getReportcode());

										List<TraceNumber> traceNumberList = traceNumberRepository
												.findByAttachmentId(Integer.valueOf(attachmentId));
										String medicalRecordNumber = refIdRepository
												.getMedicalRecordNumberByAttachmentId(Integer.valueOf(attachmentId));
										// insert the records into
										// EWV_CLAIMS_ATTACHMENT table in EWV.
										// `claimKey, `attachment_id, `reportCode,
										// `reportCodeDescription, `traceNumber,
										// `medicalRecordNumber
										EwvClaimsAttachment ewvClaimAttachment = new EwvClaimsAttachment();
										EwvClaimsAttachmentId id = new EwvClaimsAttachmentId();
										id.setEdiClaimKey(ediClaimKey);
										id.setAttachmentId(attachmentId);
										id.setReportTypeCd(ereposData.getReportcode());
										id.setReportTypeDesc(reportCodeDescription);
										id.setTraceNumber(traceNumberList.get(0).getTrn02());
										id.setMedicalRecordNumber(medicalRecordNumber);
										ewvClaimAttachment.setId(id);
										ewvClaimAttachmentRepository.save(ewvClaimAttachment);
										unmatchedResponse = true;
									} else {
										throw new GenericException(ErrorMessages.NOT_FOUND,
												"Entered PDI does not have the valid ReceiverID", HttpStatus.NOT_FOUND);
									}
								}
							} else {
								throw new GenericException(ErrorMessages.NOT_FOUND,
										"Entered PDI does not have information required for matching",
										HttpStatus.NOT_FOUND);
							}

						} else {
							throw new GenericException(ErrorMessages.NOT_FOUND, "No such PDI exists",
									HttpStatus.NOT_FOUND);
						}
					}
				} else {
					// fpps
					logger.info("idToMatch is  " + idToMatch + ", inside FPPS section, line 154");
					boolean claimIndexExists = fppsRepository.exists(Long.valueOf(idToMatch));

					if (claimIndexExists) {
						fppsClaim = fppsRepository.getClaimInformation(Long.valueOf(idToMatch));
						String ediClaimKey = fppsClaim.getEdiClaimKey().trim();

						List<IEreposDataOnly> ereposDataObject = new ArrayList<>();
						ereposDataObject = ereposClaimRepository.findClaimByClaimKey(ediClaimKey);

						/*
						 * for (Object data : ereposDataObject) { ereposData = (Ereposdata) data; }
						 */

						/*
						 * String ereposClaimKey = ereposClaim.getClaimKey(); String ereposReportCode =
						 * ereposClaim.getClaimSuplInfos().iterator().next(). getPwk01rptTypeCd();
						 */
						if ((!ereposDataObject.isEmpty()) && ereposDataObject != null) {
							logger.info("claimKey is " + ereposDataObject.get(0).getClaimkey1());
							logger.info("reportCode is " + ereposDataObject.get(0).getReport());

							ereposData.setAttachmentId(Integer.valueOf(attachmentId));
							ereposData.setClaimKey(ereposDataObject.get(0).getClaimkey1());
							ereposData.setReportcode(ereposDataObject.get(0).getReport());
							ereposData.setPayerclaimcontrolnumber("");
							ereposData.setExternalclaimid(idToMatch);

							// compare claim_key from EREPOS with claim_key from
							// FPPS
							boolean isFppsKeySameAsEreposKey = (fppsClaim.getEdiClaimKey()
									.equals(ereposData.getClaimKey()));

							if (isFppsKeySameAsEreposKey) {

								String reportCodeDescription = arsReportTypeRepository
										.getReportCodeDescriptionByReportCode(ereposData.getReportcode());

								// get receiverId from EREPOS Claim
								String receiverId = ereposRepository.getReceiverIdByClaimKey(ereposData.getClaimKey());

								if (receiverId.contains("12115") || receiverId.contains("12116")) {
									ereposDataRepository.save(ereposData);
									saveFppsDataToTransactions(attachmentId, fppsClaim, ereposData);

									// insert the records into CLAIMS_ATTACHMENT
									// table in FPPS.
									// `claimKey, `attachment_id, `reportCode,
									// `reportCodeDescription,
									// traceNumber and medicalRecordNumber can't be
									// set in CLAIM_ATTACHMENT in FPPS

									ClaimAttachments fppsClaimAttachment = new ClaimAttachments();
									ClaimAttachmentsId id = new ClaimAttachmentsId();
									id.setAttachmentId(Integer.valueOf(attachmentId));
									id.setEdiClaimKey(ediClaimKey);
									id.setReportTypeCd(ereposData.getReportcode());
									id.setReportTypeDesc(reportCodeDescription);
									fppsClaimAttachment.setId(id);
									fppsClaimAttachmentsRepository.save(fppsClaimAttachment);
									unmatchedResponse = true;
								} else {
									throw new GenericException(ErrorMessages.NOT_FOUND,
											"Entered Claim Index does not have the valid ReceiverID",
											HttpStatus.NOT_FOUND);
								}
							}

						} else {
							throw new GenericException(ErrorMessages.NOT_FOUND,
									"Entered Claim Index does not have information required for matching",
									HttpStatus.NOT_FOUND);
						}
					} else {
						throw new GenericException(ErrorMessages.NOT_FOUND, "No such Claim Index exists",
								HttpStatus.NOT_FOUND);
					}

				}

			} else {
				throw new GenericException(ErrorMessages.BAD_REQUEST, "Claim ID/PDI exceeds 15 digits",
						HttpStatus.BAD_REQUEST);
			}
		} catch (Exception e) {
			throw e;
		}

		return unmatchedResponse;

	}

	private void saveEwvDataToTransactions(String attachmentId, EwvClaims ewvClaims, Ereposdata ereposData) {

		// update the `externalClaimId, `claimkey, ?claimId, `patient DOB,
		// ?facility,
		// `reportCode
		// in transactions table
		logger.info(Integer.valueOf(attachmentId));
		Transactions transactionData = transactionsRepository.findByattachmentId(Integer.parseInt(attachmentId));
		transactionData.setExternalClaimId(ewvClaims.getPdi());
		transactionData.setClaimKey(ewvClaims.getEdiClaimKey());
		try {
			transactionData.setPatientDob(dateFormat.parse(ewvClaims.getPatientDob()));
		} catch (ParseException pex) {
			pex.printStackTrace();
		}

		// where does facility come from?
		transactionData.setVaFacilityCd("XXX");
		transactionData.setReportCode(ereposData.getReportcode());

		transactionsRepository.save(transactionData);
	}

	private void saveFppsDataToTransactions(String attachmentId, Claim fppsClaim, Ereposdata ereposData) {
		// update the `externalClaimId, `claimkey, ?claimId, `patient DOB,
		// ?facility,
		// `reportCode
		// in transactions table
		Date dateOfBirth = null;
		Transactions transaction = transactionsRepository.findByattachmentId(Integer.parseInt(attachmentId));
		transaction.setExternalClaimId(String.valueOf(fppsClaim.getClaimIndex()));
		transaction.setClaimKey(fppsClaim.getEdiClaimKey());

		for (PersonInfo personInfo : fppsClaim.getPersonInfos()) {
			dateOfBirth = personInfo.getBirthDate();
		}
		transaction.setPatientDob(dateOfBirth);

		// where does facility come from?
		transaction.setVaFacilityCd(fppsClaim.getVaFacility().getVaFacilityCd());
		transaction.setReportCode(ereposData.getReportcode());

		transactionsRepository.save(transaction);
	}

	private boolean checkclaimType(String substring) {
		List<String> claimTypeCodes = Arrays.asList("03", "04", "05", "06", "07", "08", "09", "10", "50", "60", "70",
				"91", "92", "93", "94", "95", "96", "98", "99");
		if (claimTypeCodes.contains(substring)) {
			return true;
		}
		return false;
	}
}