package gov.va.med.ars.service.impl;

import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;

import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import gov.va.med.ars.dao.ars.ARSMetadataStorageRepository;
import gov.va.med.ars.dao.ars.ArsAttachmentsStorageRepository;
import gov.va.med.ars.model.response.MetaDataResponse;
import gov.va.med.ars.service.IDashboardService;
import gov.va.med.domain.ars.ArsAttachmentsStorage;
import gov.va.med.domain.ars.ArsMetadataStorage;

@Service
public class DashboardServiceImpl implements IDashboardService {
	private static final Logger logger=LogManager.getLogger(DashboardServiceImpl.class);
	private static final String CURRENT_DATE_FORMAT = "MM/dd/yyyy";
	SimpleDateFormat format = new SimpleDateFormat(CURRENT_DATE_FORMAT);
	@Autowired
	ARSMetadataStorageRepository metaDataRepository;
	
	@Autowired 
	ArsAttachmentsStorageRepository attachmentRepository;
	
	private List<BigDecimal> usedStorageStatistic;
	private List<BigDecimal> totalStorageStatistic;
	private BigDecimal peakUsage;
	private BigDecimal averageUsage;
	@Override
	public MetaDataResponse getMetaDataDetails() {
		logger.info("Result Count : "+metaDataRepository.count());
		MetaDataResponse response = new MetaDataResponse();
	try{	
		Calendar cal = Calendar.getInstance();
		cal.setTime(new Date());
		cal.add(Calendar.DATE, -6);
		Date dateBefore7Days = cal.getTime();
		
		logger.info("From Date " + dateBefore7Days + " To Date " + new Date());
		// Fetch all the details		
		List<ArsMetadataStorage> weeklyDetails=metaDataRepository.getRecords(dateBefore7Days, new Date());
	
		for(ArsMetadataStorage record:weeklyDetails){
			logger.info("getTotalStorage"+ record.getTotalStorage() + " getAvailableStorage " + record.getAvailableStorage() + "getUsedStorage " +record.getUsedStorage() + "getStorageDate " +record.getStorageDate());
			//logger.info("getTotalStorage"+ record.getTotalStorage());
		}
		logger.info("Size of record fetched " +weeklyDetails.size());
		if(weeklyDetails.size()<7){
			ArsMetadataStorage noData=new ArsMetadataStorage();
			noData.setTotalStorage(new BigDecimal(0));
			noData.setAvailableStorage(new BigDecimal(0));
			noData.setUsedStorage(new BigDecimal(0));
			for(int missingcount=0;missingcount<=(7-weeklyDetails.size());missingcount++){
				weeklyDetails.add(0, noData);
			}
		}
		
		logger.info("Size of record modified " +weeklyDetails.size());
		
		usedStorageStatistic=new ArrayList<BigDecimal>();
		totalStorageStatistic=new ArrayList<BigDecimal>();
		peakUsage=new BigDecimal(0);
		averageUsage=new BigDecimal(0);
		for(ArsMetadataStorage record:weeklyDetails){
			usedStorageStatistic.add(record.getUsedStorage());
			totalStorageStatistic.add(record.getTotalStorage());
			if(peakUsage.compareTo(record.getUsedStorage())==-1){
				peakUsage=record.getUsedStorage();
			}
		//	averageUsage=averageUsage.add(record.getUsedStorage());
			logger.info("getTotalStorage"+ record.getTotalStorage() + " getAvailableStorage " + record.getAvailableStorage() + "getUsedStorage " +record.getUsedStorage() + "getStorageDate " +record.getStorageDate());	
		}
		cal.setTime(new Date());
		cal.add(Calendar.DATE, -7);
		Date dateBeforeWeek = cal.getTime();
		logger.info("dateBeforeWeek  "+dateBeforeWeek);
		ArsMetadataStorage recordBeforeWeek = metaDataRepository.recordBeforeWeek(dateBeforeWeek);
		if(recordBeforeWeek==null){
			averageUsage=weeklyDetails.get(weeklyDetails.size()-1).getUsedStorage().divide(new BigDecimal(7),2,RoundingMode.HALF_UP);
		}
		else
		{
			averageUsage=weeklyDetails.get(weeklyDetails.size()-1).getUsedStorage().subtract(recordBeforeWeek.getUsedStorage()).divide(new BigDecimal(7),2,RoundingMode.HALF_UP);
		}		
		response.setTotalStorage(weeklyDetails.get(weeklyDetails.size()-1).getTotalStorage());
		response.setAvailableStorage(weeklyDetails.get(weeklyDetails.size()-1).getAvailableStorage());
		response.setUsedStorage(weeklyDetails.get(weeklyDetails.size()-1).getUsedStorage());		
		response.setPeakUsage(peakUsage);
		response.setAverage(averageUsage);		
		String fromDate = format.format(dateBefore7Days);
		String toDate = format.format(new Date());
		logger.info("Formatted from date " + fromDate);		
		response.setFromDate(fromDate);			
		response.setToDate(toDate);
		response.setTotalStorageStatistic(totalStorageStatistic);
		response.setUsedStorageStatistic(usedStorageStatistic);
		if(averageUsage.compareTo(new BigDecimal(0))==0)
			response.setWeeksUntilFull(weeklyDetails.get(weeklyDetails.size()-1).getAvailableStorage().divide(averageUsage,2,RoundingMode.HALF_UP).divide(new BigDecimal(7),0,RoundingMode.HALF_UP));
			else
				response.setWeeksUntilFull(new BigDecimal(25));
		}			
	catch(Exception e ){
		return null;
	}
		return response;
	}
	@Override
	public MetaDataResponse getAttachmentsDetails() {
		
		logger.info("Result Count : "+metaDataRepository.count());
		MetaDataResponse response = new MetaDataResponse();
		try{
		Calendar cal = Calendar.getInstance();
		cal.setTime(new Date());
		cal.add(Calendar.DATE, -6);
		Date dateBefore7Days = cal.getTime();
		
		logger.info("From Date " + dateBefore7Days + " To Date " + new Date());
		// Fetch all the details		
		List<ArsAttachmentsStorage> weeklyDetails=attachmentRepository.getRecords(dateBefore7Days, new Date());		
	
		for(ArsAttachmentsStorage record:weeklyDetails){
			logger.info("getTotalStorage"+ record.getTotalStorage() + " getAvailableStorage " + record.getAvailableStorage() + "getUsedStorage " +record.getUsedStorage() + "getStorageDate " +record.getStorageDate());
			//logger.info("getTotalStorage"+ record.getTotalStorage());
		}
		logger.info("Size of record fetched " +weeklyDetails.size());
		if(weeklyDetails.size()<7){
			ArsAttachmentsStorage noData=new ArsAttachmentsStorage();
			noData.setTotalStorage(new BigDecimal(0));
			noData.setAvailableStorage(new BigDecimal(0));
			noData.setUsedStorage(new BigDecimal(0));
			noData.setTotalAttachments(new BigDecimal(0));
			noData.setAverageAttachmentsSize(new BigDecimal(0));
			for(int missingcount=0;missingcount<=(7-weeklyDetails.size());missingcount++){
				weeklyDetails.add(0, noData);
			}
		}
		
		logger.info("Size of record modified " +weeklyDetails.size());
		
		usedStorageStatistic=new ArrayList<BigDecimal>();
		totalStorageStatistic=new ArrayList<BigDecimal>();
		peakUsage=new BigDecimal(0);
		averageUsage=new BigDecimal(0);
		for(ArsAttachmentsStorage record:weeklyDetails){
			usedStorageStatistic.add(record.getUsedStorage());
			totalStorageStatistic.add(record.getTotalStorage());
			if(peakUsage.compareTo(record.getUsedStorage())==-1){
				peakUsage=record.getUsedStorage();
			}
		//	averageUsage=averageUsage.add(record.getUsedStorage());
			logger.info("getTotalStorage"+ record.getTotalStorage() + " getAvailableStorage " + record.getAvailableStorage() + "getUsedStorage " +record.getUsedStorage() + "getStorageDate " +record.getStorageDate());
			//logger.info("getTotalStorage"+ record.getTotalStorage());
		}
		
		
		cal.setTime(new Date());
		cal.add(Calendar.DATE, -7);
		Date dateBeforeWeek = cal.getTime();
		logger.info("dateBeforeWeek  "+dateBeforeWeek);
		ArsAttachmentsStorage recordBeforeWeek = attachmentRepository.recordBeforeWeek(dateBeforeWeek);
		if(recordBeforeWeek==null){
			averageUsage=weeklyDetails.get(weeklyDetails.size()-1).getUsedStorage().divide(new BigDecimal(7),2,RoundingMode.HALF_UP);
		}
		else
		{
			averageUsage=weeklyDetails.get(weeklyDetails.size()-1).getUsedStorage().subtract(recordBeforeWeek.getUsedStorage()).divide(new BigDecimal(7),2,RoundingMode.HALF_UP);
		}
		logger.info("averageUsage "+ averageUsage);		
		response.setTotalStorage(weeklyDetails.get(weeklyDetails.size()-1).getTotalStorage());
		response.setAvailableStorage(weeklyDetails.get(weeklyDetails.size()-1).getAvailableStorage());
		response.setUsedStorage(weeklyDetails.get(weeklyDetails.size()-1).getUsedStorage());		
		response.setPeakUsage(peakUsage);
		response.setAverage(averageUsage);		
		String fromDate = format.format(dateBefore7Days);
		String toDate = format.format(new Date());
		logger.info("Formatted from date " + fromDate);		
		response.setFromDate(fromDate);			
		response.setToDate(toDate);
		response.setTotalStorageStatistic(totalStorageStatistic);
		response.setUsedStorageStatistic(usedStorageStatistic);
		
		// For attachment report		
		response.setTotalAttachments(weeklyDetails.get(weeklyDetails.size()-1).getTotalAttachments());		
		response.setAverageAttachmentSize(weeklyDetails.get(weeklyDetails.size()-1).getAverageAttachmentsSize());
		if(averageUsage.compareTo(new BigDecimal(0))==0)
		response.setWeeksUntilFull(weeklyDetails.get(weeklyDetails.size()-1).getAvailableStorage().divide(averageUsage,2,RoundingMode.HALF_UP).divide(new BigDecimal(7),0,RoundingMode.HALF_UP));
		else
			response.setWeeksUntilFull(new BigDecimal(25));
		}
		catch(Exception e){
			return null;
		}
	
		return response;
	}

}
