/**
 * 
 */
package gov.va.med.ars.service.impl;

import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

import gov.va.med.ars.constants.ErrorMessages;
import gov.va.med.ars.dao.ars.HccsCdRepository;
import gov.va.med.ars.dao.ars.LoincCdRepository;
import gov.va.med.ars.dao.ars.LoincModCdRepository;
import gov.va.med.ars.exceptions.GenericException;
import gov.va.med.ars.model.request.CodeAndModifierRequest;
import gov.va.med.ars.model.request.GenericRequest;
import gov.va.med.ars.model.response.CodeAndModifierResponse;
import gov.va.med.ars.service.ICodeAndModifierService;
import gov.va.med.domain.ars.HccsCd;
import gov.va.med.domain.ars.LoincCd;
import gov.va.med.domain.ars.LoincModCd;

/**
 * @author PII
 *
 */
@Service
public class CodeAndModifierServiceImpl implements ICodeAndModifierService {

	private static final Logger logger = LogManager.getLogger(CodeAndModifierServiceImpl.class);

	@Autowired
	LoincCdRepository loincCdRepository;

	@Autowired
	LoincModCdRepository loincModCdRepository;

	@Autowired
	HccsCdRepository hccsCdRepository;

	/*
	 * (non-Javadoc)
	 * 
	 * @see
	 * gov.va.med.ars.service.ICodeAndModifierService#getCodeAndModifier(java.
	 * lang.String)
	 */
	@Override
	public List<?> getCodeAndModifier(String Url, List<String> codesToProcess) throws GenericException {
		List<CodeAndModifierResponse> responseList = null;
		List<Character> enabledValuesToProcess = new ArrayList<>();
		for(String str : codesToProcess) {
			enabledValuesToProcess.add(str.charAt(0));
		}
		if (Url.toLowerCase().contains("loincmod")) {
			List<LoincModCd> loincMdList = loincModCdRepository.findByisactiveIn(enabledValuesToProcess);
			responseList = mapCodesAndModifiers(loincMdList, LoincModCd.class);
		} else if (Url.toLowerCase().contains("loinc")) {
			List<LoincCd> loinCdList = loincCdRepository.findByisactiveIn(enabledValuesToProcess);
			responseList = mapCodesAndModifiers(loinCdList, LoincCd.class);
		} else if (Url.toLowerCase().contains("hccs")) {
			List<HccsCd> hccsCdList = hccsCdRepository.findByisactiveIn(enabledValuesToProcess);
			responseList = mapCodesAndModifiers(hccsCdList, HccsCd.class);
		} else {
			throw new GenericException(ErrorMessages.NOT_FOUND, "URL not found", HttpStatus.NOT_FOUND);
		}

		return responseList;
	}

	private List<CodeAndModifierResponse> mapCodesAndModifiers(List<?> listToMap, Class<?> class1)
			throws GenericException {
		List<CodeAndModifierResponse> codeAndModifierResponsesList = new ArrayList<>();
		if (class1.getSimpleName().equalsIgnoreCase("loinccd")) {
			for (Object object : listToMap) {
				LoincCd loincd = (LoincCd) object;
				CodeAndModifierResponse response = new CodeAndModifierResponse(loincd.getLoincId(),
						loincd.getStcloincCd(), loincd.getStcloincCdDesc(),
						(loincd.getIsactive() == 'Y' ? true : false));
				codeAndModifierResponsesList.add(response);
			}

		} else if (class1.getSimpleName().equalsIgnoreCase("loincmodcd")) {
			for (Object object : listToMap) {
				LoincModCd loinCdMd = (LoincModCd) object;
				CodeAndModifierResponse response = new CodeAndModifierResponse(loinCdMd.getLoincModId(),
						loinCdMd.getStcloincCdMod(), loinCdMd.getStcloincCdModDesc(),
						(loinCdMd.getIsactive() == 'Y' ? true : false));
				codeAndModifierResponsesList.add(response);
			}

		} else if (class1.getSimpleName().equalsIgnoreCase("hccscd")) {
			for (Object object : listToMap) {
				HccsCd hccdCd = (HccsCd) object;
				CodeAndModifierResponse response = new CodeAndModifierResponse(hccdCd.getHccsId(),
						hccdCd.getStchccstatuscatCd(), hccdCd.getStchccstatuscatCdDesc(),
						(hccdCd.getIsactive() == 'Y' ? true : false));
				codeAndModifierResponsesList.add(response);
			}

		} else {
			throw new GenericException(ErrorMessages.DATA_ACCESS_ERROR, "Internal Error occured",
					HttpStatus.INTERNAL_SERVER_ERROR);
		}
		return codeAndModifierResponsesList;
	}

	@Override
	public boolean addOrModifyCodeAndModifier(GenericRequest codeAndModifier) throws GenericException {
		boolean response = false;
		if (codeAndModifier.getLoincModList() != null && codeAndModifier.getLoincModList().size() > 0) {
			response = saveCodesAndModifiers(codeAndModifier.getLoincModList(), LoincModCd.class);
		}
		if (codeAndModifier.getLoincList() != null && codeAndModifier.getLoincList().size() > 0) {
			response = saveCodesAndModifiers(codeAndModifier.getLoincList(), LoincCd.class);
		}
		if (codeAndModifier.getHccList() != null && codeAndModifier.getHccList().size() > 0) {
			response = saveCodesAndModifiers(codeAndModifier.getHccList(), HccsCd.class);
		}
		return response;
	}

	private boolean saveCodesAndModifiers(List<?> listToMap, Class<?> class1) {
		LoincCd loincCdResponse = null;
		LoincModCd loincModCdResponse = null;
		HccsCd hccsCdResponse = null;
		if (class1.getSimpleName().equalsIgnoreCase("loinccd")) {
			for (Object object : listToMap) {
				CodeAndModifierRequest codeAndModifier = (CodeAndModifierRequest) object;
				LoincCd loincCodeDb = null;
				LoincCd loincCd = new LoincCd();
				loincCd.setStcloincCd(codeAndModifier.getStcCd());
				loincCd.setStcloincCdDesc(codeAndModifier.getStcCdDesc());
				loincCd.setDatemodified(new Date());
				if (codeAndModifier.isFlag()) {
					loincCd.setIsactive('Y');
				} else {
					loincCd.setIsactive('N');
				}
				if (codeAndModifier.getCd() != null || !StringUtils.isEmpty(codeAndModifier.getCd())) {
					loincCodeDb = loincCdRepository.findOne(codeAndModifier.getCd());
				}
				if (loincCodeDb == null) {
					loincCd.setDatecreated(new Date());
					loincCdResponse = loincCdRepository.save(loincCd);
				} else {
					loincCd.setLoincId(loincCodeDb.getLoincId());
					loincCd.setDatecreated(loincCodeDb.getDatecreated());
					loincCdResponse = loincCdRepository.save(loincCd);
				}
			}
		}

		if (class1.getSimpleName().equalsIgnoreCase("loincmodcd")) {
			for (Object object : listToMap) {
				CodeAndModifierRequest codeAndModifier = (CodeAndModifierRequest) object;
				LoincModCd loincCodeModDb = null;
				LoincModCd loincModCd = new LoincModCd();
				loincModCd.setStcloincCdMod(codeAndModifier.getStcCd());
				loincModCd.setStcloincCdModDesc(codeAndModifier.getStcCdDesc());
				loincModCd.setDatemodified(new Date());
				if (codeAndModifier.isFlag()) {
					loincModCd.setIsactive('Y');
				} else {
					loincModCd.setIsactive('N');
				}
				if (codeAndModifier.getCd() != null || !StringUtils.isEmpty(codeAndModifier.getCd())) {
					loincCodeModDb = loincModCdRepository.findOne(codeAndModifier.getCd());
				}
				if (loincCodeModDb == null) {
					loincModCd.setDatecreated(new Date());
					loincModCdResponse = loincModCdRepository.saveAndFlush(loincModCd);
				} else {
					loincModCd.setLoincModId(loincCodeModDb.getLoincModId());
					loincModCd.setDatecreated(loincCodeModDb.getDatecreated());
					loincModCdResponse = loincModCdRepository.save(loincModCd);
				}
			}
		}

		if (class1.getSimpleName().equalsIgnoreCase("hccscd")) {
			for (Object object : listToMap) {
				CodeAndModifierRequest codeAndModifier = (CodeAndModifierRequest) object;
				HccsCd hccsCodeDb = null;
				HccsCd hccsCd = new HccsCd();
				hccsCd.setStchccstatuscatCd(codeAndModifier.getStcCd());
				hccsCd.setStchccstatuscatCdDesc(codeAndModifier.getStcCdDesc());
				hccsCd.setDatemodified(new Date());
				if (codeAndModifier.isFlag()) {
					hccsCd.setIsactive('Y');
				} else {
					hccsCd.setIsactive('N');
				}
				if (codeAndModifier.getCd() != null || !StringUtils.isEmpty(codeAndModifier.getCd())) {
					hccsCodeDb = hccsCdRepository.findOne(codeAndModifier.getCd());
				}
				if (hccsCodeDb == null) {
					hccsCd.setDatecreated(new Date());
					hccsCdResponse = hccsCdRepository.saveAndFlush(hccsCd);
				} else {
					hccsCd.setHccsId(hccsCodeDb.getHccsId());
					hccsCd.setDatecreated(hccsCodeDb.getDatecreated());
					hccsCdResponse = hccsCdRepository.save(hccsCd);
				}
			}
		}
		if (loincCdResponse != null || loincModCdResponse != null || hccsCdResponse != null) {
			return true;
		}
		return false;
	}

	@Override
	public List<String> checkSubmittedModificationsForDupes(GenericRequest codeAndModifierRequest) {

		List<String> returnList = new LinkedList<>();

		if (codeAndModifierRequest.getLoincModList() != null && !codeAndModifierRequest.getLoincModList().isEmpty()) {
			returnList.addAll(checkCodesAndModifiers(codeAndModifierRequest.getLoincModList(), LoincModCd.class));
		}
		if (codeAndModifierRequest.getLoincList() != null && !codeAndModifierRequest.getLoincList().isEmpty()) {
			returnList.addAll(checkCodesAndModifiers(codeAndModifierRequest.getLoincList(), LoincCd.class));
		}
		if (codeAndModifierRequest.getHccList() != null && !codeAndModifierRequest.getHccList().isEmpty()) {
			returnList.addAll(checkCodesAndModifiers(codeAndModifierRequest.getHccList(), HccsCd.class));
		}
		return returnList;

	}

	private List<String> checkCodesAndModifiers(List<?> listToCheck, Class<?> class1) {

		List<String> errorList = new LinkedList<>();

		if (class1.getSimpleName().equalsIgnoreCase("hccscd")) {

			for (Object object : listToCheck) {

				CodeAndModifierRequest codeAndModifier = (CodeAndModifierRequest) object;

				if (codeAndModifier != null
						&& (codeAndModifier.getCd() == null || StringUtils.isEmpty(codeAndModifier.getCd()))) {

					HccsCd lookedUpHccsCd = hccsCdRepository.findOneByStchccstatuscatCd(codeAndModifier.getStcCd());

					if (lookedUpHccsCd != null) {

						logger.warn(String.format("Found an already existing item for request: %s",
								codeAndModifier.toString()));

						errorList.add(addDuplicateCodeError(codeAndModifier, class1));

					}
				}
			}
		}
		if (class1.getSimpleName().equalsIgnoreCase("loinccd")) {

			for (Object object : listToCheck) {

				CodeAndModifierRequest codeAndModifier = (CodeAndModifierRequest) object;

				if (codeAndModifier != null
						&& (codeAndModifier.getCd() == null || StringUtils.isEmpty(codeAndModifier.getCd()))) {

					LoincCd lookedUpHccsCd = loincCdRepository.findOneByStcloincCd(codeAndModifier.getStcCd());

					if (lookedUpHccsCd != null) {
						errorList.add(addDuplicateCodeError(codeAndModifier, class1));
					}
				}

			}
		}
		if (class1.getSimpleName().equalsIgnoreCase("loincmodcd")) {

			for (Object object : listToCheck) {

				CodeAndModifierRequest codeAndModifier = (CodeAndModifierRequest) object;

				if (codeAndModifier != null
						&& (codeAndModifier.getCd() == null || StringUtils.isEmpty(codeAndModifier.getCd()))) {

					LoincModCd lookedUpHccsCd = loincModCdRepository.findOneByStcloincCdMod(codeAndModifier.getStcCd());

					if (lookedUpHccsCd != null) {
						errorList.add(addDuplicateCodeError(codeAndModifier, class1));
					}
				}
			}
		}
		return errorList;
	}

	private String addDuplicateCodeError(CodeAndModifierRequest codeAndModifier, Class<?> class1) {

		String formalCodeName = null;

		switch (class1.getSimpleName().toLowerCase()) {
		case "hccscd":
			formalCodeName = "HCCS Code";
			break;
		case "loinccd":
			formalCodeName = "LOINC Code";
			break;
		case "loincmodcd":
			formalCodeName = "LOINC Modifier Code";
			break;
		}

		return String.format("Duplicate Found: %s of type %s ", codeAndModifier.getStcCd(), formalCodeName);
	}

}
