package gov.va.med.ars.service.impl;

import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.Properties;

import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Configurable;
import org.springframework.stereotype.Service;

import gov.va.med.ars.dao.ars.ClaimSubmissionRepository;
import gov.va.med.ars.exceptions.GenericException;
import gov.va.med.ars.model.request.ArsMailRequest;
import gov.va.med.ars.service.IArsMailService;
import gov.va.med.domain.ars.ClaimSubmission;

@Service
@Configurable
public class ArsMailServiceImpl implements IArsMailService {
	private static final Logger logger = LogManager.getLogger(ArsMailServiceImpl.class);
	private static final String BREAK = "<br/>";

	@Autowired
	private ClaimSubmissionRepository claimSubmissionRepository;
    
	@Override
	public String sendArsMail(ArsMailRequest request) throws GenericException {
		String[] recipients = new String[request.getEmailTo().size()];
		recipients = request.getEmailTo().toArray(recipients);
		boolean debug = false;
		String ret = "";
		
		// Set the host smtp address
		Properties props = new Properties();
		props.put("mail.smtp.host", "DNS        ");
		props.put("mail.host", "DNS        ");

		// create some properties and get the default Session
		Session session = Session.getInstance (props);
		session.setDebug(debug);

		// create a message
		Message msg = new MimeMessage(session);

		// set the from and to address
		InternetAddress addressFrom;
		try {
			addressFrom = new InternetAddress(request.getEmailFrom());
			msg.setFrom(addressFrom);
		} catch (Exception e1) {
			// TODO Auto-generated catch block
			e1.printStackTrace();
		}
		
		InternetAddress[] addressTo = new InternetAddress[recipients.length];
		
		try {
			for (int i = 0; i < recipients.length; i++) {
				if (recipients[i] != null && !recipients[i].equals("")) {
					InternetAddress addressTemp = new InternetAddress(recipients[i]);
					addressTemp.validate();
					addressTo[i] = addressTemp;
				}
			}
			msg.setRecipients(Message.RecipientType.TO, addressTo);

			ClaimSubmission claimSubmission = claimSubmissionRepository.findOne(Long.parseLong(request.getSubmissionId()));

			// Setting the Subject and Content Type
			msg.setSubject("ARS Submission " + claimSubmission.getSubmissionid() + " Update");
			msg.setContent(buildEmailBody(claimSubmission), "text/html");
			Transport.send(msg);
			GregorianCalendar gc = new GregorianCalendar();
			String dts = (gc.get(Calendar.MONTH) + 1) + "/" + gc.get(Calendar.DAY_OF_MONTH) + "/"
					+ gc.get(Calendar.YEAR) + " at " + gc.get(Calendar.HOUR_OF_DAY) + ":"
					+ gc.get(Calendar.MINUTE) + ":" + gc.get(Calendar.SECOND);
			ret += "message sent at " + dts;
		} catch (AddressException ae) {
			ret += "AddressException ERROR: " + ae.getMessage();
			logger.error(ae.getMessage(), ae);
		} catch (MessagingException me) {
			ret += "MessagingException Error: " + me.getMessage();
			logger.error(me.getMessage(), me);
		} catch (Exception e) {
			ret += "Exception Error: " + e.getMessage();
			logger.error(e.getMessage(), e);
		}
		return ret;
	}
	
	public static String buildEmailBody(ClaimSubmission claimSubmission) {
    	//create the email body
    	StringBuffer emailBodyBuffer = new StringBuffer();
    	String emailBody="The submission " + claimSubmission.getSubmissionid() + " for the following claim " + claimSubmission.getTrn02fppsClaimId() + " has been updated to " + claimSubmission.getSubmissionStatus();
    	emailBodyBuffer.append("Hello,");
    	emailBodyBuffer.append(BREAK);
    	emailBodyBuffer.append(BREAK);
    	emailBodyBuffer.append(emailBody);
    	emailBodyBuffer.append(BREAK);
    	emailBodyBuffer.append(BREAK);
    	emailBodyBuffer.append("Thanks,");
    	emailBodyBuffer.append(BREAK);
        emailBodyBuffer.append("ARS Robotic Program");
        emailBodyBuffer.append(BREAK);
        emailBodyBuffer.append(BREAK);
        emailBodyBuffer.append("<a href='https://URL:PORT'>ARS Login in</a>");
    	return emailBodyBuffer.toString();
    }
}