package gov.va.med.ars.service.impl;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import gov.va.med.ars.dao.ars.EmailTemplateRepository;
import gov.va.med.ars.exceptions.GenericException;
import gov.va.med.ars.model.request.EmailTemplateRequest;
import gov.va.med.ars.service.IArsEmailTemplateService;
import gov.va.med.domain.ars.EmailTemplate;

/**
 * @author Kawsar, Hayes
 * Changed the get call to a list and fixed the way it gets the responses
 * @author PII
 *
 */
@Service
public class ArsEmailTemplateServiceImpl implements IArsEmailTemplateService {
	private static final Logger logger = LogManager.getLogger(ArsEmailTemplateServiceImpl.class);
		
	@Autowired
	private EmailTemplateRepository emailRepo;


	@Override
	public List<EmailTemplateRequest> getEmailTemplate() throws GenericException {
		EmailTemplateRequest template = null;
		List<EmailTemplateRequest> templateList = new ArrayList<>();
		List<EmailTemplate> emailTemplateList = null;
		try {
			emailTemplateList = emailRepo.findAll();
		} catch (Exception e) {
			logger.error("ArsEmailTemplateServiceImpl.getEmailTemplateByType() : exception occured while retrieving data.");
		}

		if(emailTemplateList != null && emailTemplateList.size() > 0) {
			for(EmailTemplate emailTemplate: emailTemplateList) {
				template = new EmailTemplateRequest();
				template.setTemplateType(emailTemplate.getEmailTemplateType());
				template.setHeading(emailTemplate.getEmailTemplateHeader());
				template.setMessage(emailTemplate.getEmailTemplateBody());
				template.setTemplateName(emailTemplate.getEmailTemplateType());
				template.setModifiedBy(emailTemplate.getModifiedBy());
				templateList.add(template);
			}
		}
		return templateList;
	}

	@Override
	public boolean updateEmailTemplate(EmailTemplateRequest request) throws GenericException {
		Date date = new Date();
		SimpleDateFormat simpleDateFormat = new SimpleDateFormat("MM/dd/yyyy HH:mm:ss");
		simpleDateFormat.format(date);
		EmailTemplate emailTemplate = emailRepo.getEmailTemplateByType(request.getTemplateName());
		EmailTemplate templateToUpdate = emailRepo.findOne(emailTemplate.getEmailTemplateId());
		templateToUpdate.setEmailTemplateHeader(request.getHeading());
		templateToUpdate.setEmailTemplateBody(request.getMessage());
		templateToUpdate.setDateModified(date);
		templateToUpdate.setModifiedBy(request.getModifiedBy());
		EmailTemplate updatedTemplate = emailRepo.save(templateToUpdate);
		
		return (updatedTemplate != null) ? true : false;
	}
}