package gov.va.med.ars.service.impl;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;

import java.util.List;

import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import gov.va.med.ars.dao.ars.ArsAttachmentsStorageRepository;
import gov.va.med.ars.exceptions.GenericException;
import gov.va.med.ars.model.response.AttachmentsStorageResponse;
import gov.va.med.ars.service.IArsAttachmentsStorageService;
import gov.va.med.domain.ars.ArsAttachmentsStorage;

@Service
public class ArsAttachmentsStorageServiceImpl implements IArsAttachmentsStorageService {
	
	private static final Logger logger=LogManager.getLogger(DashboardServiceImpl.class);
	private static final String CURRENT_DATE_FORMAT = "yyyyMMdd";
	SimpleDateFormat format = new SimpleDateFormat(CURRENT_DATE_FORMAT);
	
	@Autowired
	private ArsAttachmentsStorageRepository arsAttachStorageRepo;
	
	private List<BigDecimal> usedStorageStatistic;
	private List<BigDecimal> totalStorageStatistic;
	private BigDecimal peakUsage;
	private BigDecimal averageUsage;

	@Override
	public AttachmentsStorageResponse getAttachemntsStorageInfo() throws GenericException {
		Date today = new Date();
		Calendar cal = Calendar.getInstance();
		cal.setTime(today);
		cal.add(Calendar.DATE, -6);
		Date dateBeforeSevenDays = cal.getTime();
		
		AttachmentsStorageResponse response = new AttachmentsStorageResponse();
		
		List<ArsAttachmentsStorage> arsAttachmentStorage = arsAttachStorageRepo.getArsAttachmentsStorageInfo(dateBeforeSevenDays);

		for(ArsAttachmentsStorage storageInfo : arsAttachmentStorage) {
			logger.info("getTotalStorage"+ storageInfo.getTotalStorage() + " getAvailableStorage " 
					+ storageInfo.getAvailableStorage() + "getUsedStorage " +storageInfo.getUsedStorage() 
					+ "getStorageDate " +storageInfo.getStorageDate());
			
			logger.info("Size of record fetched " +arsAttachmentStorage.size());

		}
		
		if(arsAttachmentStorage.size()<7){
			ArsAttachmentsStorage noData=new ArsAttachmentsStorage();
			noData.setTotalStorage(new BigDecimal(0));
			noData.setAvailableStorage(new BigDecimal(0));
			noData.setUsedStorage(new BigDecimal(0));
			for(int missingcount = 0; missingcount <= (7-arsAttachmentStorage.size()); missingcount++) {
				arsAttachmentStorage.add(0, noData);
			}
		}
		
		logger.info("Size of record modified " +arsAttachmentStorage.size());
		
		usedStorageStatistic=new ArrayList<BigDecimal>();
		totalStorageStatistic=new ArrayList<BigDecimal>();
		peakUsage=new BigDecimal(0);
		averageUsage=new BigDecimal(0);
		
		for(ArsAttachmentsStorage record:arsAttachmentStorage){
			usedStorageStatistic.add(record.getUsedStorage());
			totalStorageStatistic.add(record.getTotalStorage());
			if(peakUsage.compareTo(record.getUsedStorage())<0){
				peakUsage=record.getUsedStorage();
			}
			averageUsage.add(record.getUsedStorage());
			logger.info("getTotalStorage"+ record.getTotalStorage() + " getAvailableStorage " + record.getAvailableStorage() 
				+ "getUsedStorage " +record.getUsedStorage() + "getStorageDate " +record.getStorageDate());

		}
		
		response.setTotalStorage(arsAttachmentStorage.get(arsAttachmentStorage.size()-1).getTotalStorage());
		response.setAvailableStorage(arsAttachmentStorage.get(arsAttachmentStorage.size()-1).getAvailableStorage());
		response.setTotalAttachments(arsAttachmentStorage.get(arsAttachmentStorage.size()-1).getTotalAttachments());
		response.setUsedStorage(arsAttachmentStorage.get(arsAttachmentStorage.size()-1).getUsedStorage());
		response.setAvgAttachSize(arsAttachmentStorage.get(arsAttachmentStorage.size()-1).getAverageAttachmentsSize());
		
		response.setPeakUsage(peakUsage);
		response.setAverage(averageUsage.divide(new BigDecimal(7)));		
		String fromDate = format.format(dateBeforeSevenDays);
		String toDate = format.format(new Date());
		logger.info("Formatted from date " + fromDate);		
		response.setFromDate(fromDate);			
		response.setToDate(toDate);
		response.setTotalStorageStatistic(totalStorageStatistic);
		response.setUsedStorageStatistic(usedStorageStatistic);
	
		return response;
	}
}