/**
 * 
 */
package gov.va.med.ars.service.impl;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import gov.va.med.ars.dao.ars.IClaimAttachmentsViewRepository;
import gov.va.med.ars.service.IArchiveService;
import gov.va.med.domain.ars.ClaimattachmentsView;

/**
 * @author PII
 *
 */
@Service
public class ArchiveServiceImpl implements IArchiveService {
	
	private static final Logger logger = LogManager.getLogger(ArchiveServiceImpl.class);

	@Autowired
	IClaimAttachmentsViewRepository iClaimAttachmentsViewRepository;

	/* (non-Javadoc)
	 * @see gov.va.med.ars.service.IArchiveService#archiveAttachmentId()
	 */
	@Override
	public boolean archiveAttachmentId(long attachmentId) {
		boolean isArchived = false;
		ClaimattachmentsView claimAttachmnetsView = iClaimAttachmentsViewRepository.findOne(attachmentId);
		if(claimAttachmnetsView != null) {
			claimAttachmnetsView.setAttachmentMoved(1);
			iClaimAttachmentsViewRepository.save(claimAttachmnetsView);
			isArchived = true;
		} else {
			logger.info("Error occured as there is no data in Claim Attachments View table with the Attachment Id: "+attachmentId);
		}
		return isArchived;
	}

}
