/**
 * 
 */
package gov.va.med.ars.security;

import java.net.URLDecoder;
import java.net.URLEncoder;
import java.text.MessageFormat;

import javax.servlet.http.HttpServletRequest;

import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import gov.va.med.ars.exceptions.GenericException;
import gov.va.med.ars.model.request.DecryptionRequest;
import gov.va.med.ars.model.request.EncryptUrl;
import gov.va.med.ars.model.response.EncryptUrlResponse;
import gov.va.med.ars.model.response.UserInfoResponse;
import gov.va.med.ars.service.IAuthenticatorService;
import net.minidev.json.JSONObject;

/**
 * @author PII
 *
 */
@RestController
@RequestMapping("/api/v1/authorize")
public class SsoAuthorizationController {

	private static final Logger logger = LogManager.getLogger(SsoAuthorizationController.class);

	@Autowired
	IAuthenticatorService authenticatorService;

	@Value("${postBack.url}")
	String postBackUrl;

	@Value("${captured.url}")
	String capturedUrl;

	@PostMapping("/encryptUrl")
	public ResponseEntity<?> getEncryptedUrls(@RequestBody EncryptUrl encryptUrl, HttpServletRequest request) {
		EncryptUrlResponse encryptedUrlResponse = new EncryptUrlResponse();
		JSONObject object = new JSONObject();

		try {
			String encryptedCapturedUrl = AesEncryption
					.encrypt(MessageFormat.format(capturedUrl, encryptUrl.getHostname()));
			encryptedUrlResponse.setEncodedCapturedUrl(URLEncoder.encode(encryptedCapturedUrl, "UTF-8"));

			String encryptedForwardUrl = AesEncryption
					.encrypt(MessageFormat.format(postBackUrl, encryptUrl.getHostname()));
			encryptedUrlResponse.setEncodedPostBackUrl(
					URLEncoder.encode(MessageFormat.format(encryptedForwardUrl, encryptUrl.getHostname()), "UTF-8"));
			encryptedUrlResponse.setSessionInformation(request.getSession().getId().toString());
			return new ResponseEntity<>(encryptedUrlResponse, HttpStatus.OK);
		} catch (Exception e) {
			object.put("encryptedUrlResponse", "Error parsing the hostname");
			return new ResponseEntity<>(object, HttpStatus.BAD_REQUEST);
		}
	}

	@PostMapping("/decryptUrl")
	public ResponseEntity<?> getNtName(@RequestBody DecryptionRequest decryptedRequest) throws GenericException {
		String decryptedNTUsername = null;
		JSONObject response = null;
		try {
			if (!StringUtils.isEmpty(decryptedRequest.getGetNtname())) {
				String username = URLDecoder.decode(decryptedRequest.getGetNtname(), "UTF-8");
				decryptedNTUsername = AesEncryption.decrypt(username);

				// Authenticate the User First
				boolean isAuthenticated = authenticatorService.authenticateUser(decryptedNTUsername);
				UserInfoResponse userRolesResponse;
				if (isAuthenticated) {
					// Get UserRoles
					userRolesResponse = authenticatorService.getUserRoles();
					if (userRolesResponse != null && !(userRolesResponse.getUserRoles().isEmpty())) {
						return new ResponseEntity<>(userRolesResponse, HttpStatus.OK);
					} else {
						response = new JSONObject();
						logger.warn("getUserRoles : 0 Roles found for " + decryptedNTUsername);
						response.put("errorCode", "Un-Authorized");
						response.put("message", "The entered user has no access to the application");
						return new ResponseEntity<>(response, HttpStatus.NOT_FOUND);
					}
				} else {
					response = new JSONObject();
					logger.error("getUserRoles : Authentication failed for userName: " + decryptedNTUsername);
					response.put("errorCode", "Invalid User");
					response.put("message", "The entered user has no access to the application");
					throw new GenericException("", "", HttpStatus.ACCEPTED);
				}
			} else {
				response = new JSONObject();
				logger.warn("Windows NT name not found " + decryptedNTUsername);
				response.put("errorCode", "Un-Authorized");
				response.put("message", "The entered user has no access to the application");
				return new ResponseEntity<>(response, HttpStatus.NOT_FOUND);
			}

		} catch (Exception e) {
			response = new JSONObject();
			logger.warn("Internal error occured " + decryptedNTUsername);
			response.put("errorCode", "Un-Authorized");
			response.put("message", "The entered user has no access to the application");
			return new ResponseEntity<>(response, HttpStatus.NOT_FOUND);
		}
	}
}
