/**
 *  @author Eyuel Taddese
 *
 */
package gov.va.med.ars.model.response;

import com.fasterxml.jackson.annotation.JsonInclude;

public class UserRoles {

	@JsonInclude(JsonInclude.Include.NON_NULL)
	private Long arsRoleId;
	private String roleName;
	private String description;

	/**
	 * 
	 */
	public UserRoles() {
	}

	public UserRoles(String roleName, String description) {
		super();
		this.roleName = roleName;
		this.description = description;
	}

	public UserRoles(Long arsRoleId, String roleName, String description) {
		super();
		this.arsRoleId = arsRoleId;
		this.roleName = roleName;
		this.description = description;
	}

	/**
	 * @return the arsRoleId
	 */
	public Long getArsRoleId() {
		return arsRoleId;
	}

	/**
	 * @param arsRoleId the arsRoleId to set
	 */
	public void setArsRoleId(Long arsRoleId) {
		this.arsRoleId = arsRoleId;
	}

	/**
	 * @return the roleName
	 */
	@JsonInclude(JsonInclude.Include.NON_NULL)
	public String getRoleName() {
		return roleName;
	}

	/**
	 * @param roleName
	 *            the roleName to set
	 */
	public void setRoleName(String roleName) {
		this.roleName = roleName;
	}

	/**
	 * @return the description
	 */
	@JsonInclude(JsonInclude.Include.NON_NULL)
	public String getDescription() {
		return description;
	}

	/**
	 * @param description
	 *            the description to set
	 */
	public void setDescription(String description) {
		this.description = description;
	}

	/* (non-Javadoc)
	 * @see java.lang.Object#hashCode()
	 */
	@Override
	public int hashCode() {
		final int prime = 31;
		int result = 1;
		result = prime * result + (int) (arsRoleId ^ (arsRoleId >>> 32));
		result = prime * result + ((description == null) ? 0 : description.hashCode());
		result = prime * result + ((roleName == null) ? 0 : roleName.hashCode());
		return result;
	}

	/* (non-Javadoc)
	 * @see java.lang.Object#equals(java.lang.Object)
	 */
	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (getClass() != obj.getClass())
			return false;
		UserRoles other = (UserRoles) obj;
		if (arsRoleId != other.arsRoleId)
			return false;
		if (description == null) {
			if (other.description != null)
				return false;
		} else if (!description.equals(other.description))
			return false;
		if (roleName == null) {
			if (other.roleName != null)
				return false;
		} else if (!roleName.equals(other.roleName))
			return false;
		return true;
	}

	/* (non-Javadoc)
	 * @see java.lang.Object#toString()
	 */
	@Override
	public String toString() {
		return "UserRoles [arsRoleId=" + arsRoleId + ", roleName=" + roleName + ", description=" + description + "]";
	}	
}
