package gov.va.med.ars.model.response;

import java.math.BigDecimal;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;

/**
 * @author PII
 *
 */
@JsonIgnoreProperties(ignoreUnknown = true)
public class RfaiLineItemResponse {
	
	private Long serviceLineId;
	private String serviceFrom;
	private String serviceTo;
	private String revenueCode;
	private String procedureCode;
	private String modifiers;
	private BigDecimal chargeAmount;
	/**
	 * 
	 */
	public RfaiLineItemResponse() {
		super();
		// TODO Auto-generated constructor stub
	}
	/**
	 * @param serviceLineId
	 * @param serviceFrom
	 * @param serviceTo
	 * @param revenueCode
	 * @param procedureCode
	 * @param modifiers
	 * @param chargeAmount
	 */
	public RfaiLineItemResponse(Long serviceLineId, String serviceFrom, String serviceTo, String revenueCode,
			String procedureCode, String modifiers, BigDecimal chargeAmount) {
		super();
		this.serviceLineId = serviceLineId;
		this.serviceFrom = serviceFrom;
		this.serviceTo = serviceTo;
		this.revenueCode = revenueCode;
		this.procedureCode = procedureCode;
		this.modifiers = modifiers;
		this.chargeAmount = chargeAmount;
	}
	/**
	 * @return the serviceLineId
	 */
	public Long getServiceLineId() {
		return serviceLineId;
	}
	/**
	 * @param serviceLineId the serviceLineId to set
	 */
	public void setServiceLineId(Long serviceLineId) {
		this.serviceLineId = serviceLineId;
	}
	/**
	 * @return the serviceFrom
	 */
	public String getServiceFrom() {
		return serviceFrom;
	}
	/**
	 * @param serviceFrom the serviceFrom to set
	 */
	public void setServiceFrom(String serviceFrom) {
		this.serviceFrom = serviceFrom;
	}
	/**
	 * @return the serviceTo
	 */
	public String getServiceTo() {
		return serviceTo;
	}
	/**
	 * @param serviceTo the serviceTo to set
	 */
	public void setServiceTo(String serviceTo) {
		this.serviceTo = serviceTo;
	}
	/**
	 * @return the revenueCode
	 */
	public String getRevenueCode() {
		return revenueCode;
	}
	/**
	 * @param revenueCode the revenueCode to set
	 */
	public void setRevenueCode(String revenueCode) {
		this.revenueCode = revenueCode;
	}
	/**
	 * @return the procedureCode
	 */
	public String getProcedureCode() {
		return procedureCode;
	}
	/**
	 * @param procedureCode the procedureCode to set
	 */
	public void setProcedureCode(String procedureCode) {
		this.procedureCode = procedureCode;
	}
	/**
	 * @return the modifiers
	 */
	public String getModifiers() {
		return modifiers;
	}
	/**
	 * @param modifiers the modifiers to set
	 */
	public void setModifiers(String modifiers) {
		this.modifiers = modifiers;
	}
	/**
	 * @return the chargeAmount
	 */
	public BigDecimal getChargeAmount() {
		return chargeAmount;
	}
	/**
	 * @param chargeAmount the chargeAmount to set
	 */
	public void setChargeAmount(BigDecimal chargeAmount) {
		this.chargeAmount = chargeAmount;
	}
	/* (non-Javadoc)
	 * @see java.lang.Object#toString()
	 */
	@Override
	public String toString() {
		StringBuilder builder = new StringBuilder();
		builder.append("RfaiLineItemResponse [serviceLineId=");
		builder.append(serviceLineId);
		builder.append(", serviceFrom=");
		builder.append(serviceFrom);
		builder.append(", serviceTo=");
		builder.append(serviceTo);
		builder.append(", revenueCode=");
		builder.append(revenueCode);
		builder.append(", procedureCode=");
		builder.append(procedureCode);
		builder.append(", modifiers=");
		builder.append(modifiers);
		builder.append(", chargeAmount=");
		builder.append(chargeAmount);
		builder.append("]");
		return builder.toString();
	}
	/* (non-Javadoc)
	 * @see java.lang.Object#hashCode()
	 */
	@Override
	public int hashCode() {
		final int prime = 31;
		int result = 1;
		result = prime * result + ((chargeAmount == null) ? 0 : chargeAmount.hashCode());
		result = prime * result + ((modifiers == null) ? 0 : modifiers.hashCode());
		result = prime * result + ((procedureCode == null) ? 0 : procedureCode.hashCode());
		result = prime * result + ((revenueCode == null) ? 0 : revenueCode.hashCode());
		result = prime * result + ((serviceFrom == null) ? 0 : serviceFrom.hashCode());
		result = prime * result + ((serviceLineId == null) ? 0 : serviceLineId.hashCode());
		result = prime * result + ((serviceTo == null) ? 0 : serviceTo.hashCode());
		return result;
	}
	/* (non-Javadoc)
	 * @see java.lang.Object#equals(java.lang.Object)
	 */
	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (getClass() != obj.getClass())
			return false;
		RfaiLineItemResponse other = (RfaiLineItemResponse) obj;
		if (chargeAmount == null) {
			if (other.chargeAmount != null)
				return false;
		} else if (!chargeAmount.equals(other.chargeAmount))
			return false;
		if (modifiers == null) {
			if (other.modifiers != null)
				return false;
		} else if (!modifiers.equals(other.modifiers))
			return false;
		if (procedureCode == null) {
			if (other.procedureCode != null)
				return false;
		} else if (!procedureCode.equals(other.procedureCode))
			return false;
		if (revenueCode == null) {
			if (other.revenueCode != null)
				return false;
		} else if (!revenueCode.equals(other.revenueCode))
			return false;
		if (serviceFrom == null) {
			if (other.serviceFrom != null)
				return false;
		} else if (!serviceFrom.equals(other.serviceFrom))
			return false;
		if (serviceLineId == null) {
			if (other.serviceLineId != null)
				return false;
		} else if (!serviceLineId.equals(other.serviceLineId))
			return false;
		if (serviceTo == null) {
			if (other.serviceTo != null)
				return false;
		} else if (!serviceTo.equals(other.serviceTo))
			return false;
		return true;
	}
}
