package gov.va.med.ars.model.response;

import java.util.List;

import com.fasterxml.jackson.annotation.JsonInclude;

public class Rfai277SubmissionResponse {

	@JsonInclude(JsonInclude.Include.NON_NULL)
	private Long claimId; 
	private String contactInfo;
	private String rfaiStatus; 
	private String rfaiSubmissionDate; 
	private String payerName; 
	private String payerId; 
	private String informationReceiver;  
	private String responseDate; 
	private String billingProvider; 
	private String providerNpi;  
	private String providerTin; 
	private String patientLastname; 
	private String patientFirstName; 
	private String patientIdentifier; 
	private String patientcontrolNumber;
	private String payerClaimControlNumber; 
	private String billType; 
	private String clearingHouseId; 
	private String medicalRecordNumber;  

	@JsonInclude(JsonInclude.Include.NON_NULL)
	private List<RfaiRelatedItemResponse> rfaiRelatedItemResponse;
	
	@JsonInclude(JsonInclude.Include.NON_NULL)
	private List<RfaiAttachmentResponse> rfaiAttachmentResponse;
	
	@JsonInclude(JsonInclude.Include.NON_NULL)
	private List<RfaiLineItemResponse> rfaiLineItemResponse;
		
	/**
	 * 
	 */
	public Rfai277SubmissionResponse() {
		super();
	}
	
	/**
	 * 
	 * @param claimId
	 * @param contactInfo
	 * @param rfaiStatus
	 * @param rfaiSubmissionDate
	 * @param payerName
	 * @param payerId
	 * @param informationReceiver
	 * @param responseDate
	 * @param billingProvider
	 * @param providerNpi
	 * @param providerTin
	 * @param patientLastname
	 * @param patientFirstName
	 * @param patientIdentifier
	 * @param patientcontrolNumber
	 * @param payerClaimControlNumber
	 * @param billType
	 * @param clearingHouseId
	 * @param medicalRecordNumber
	 */
	public Rfai277SubmissionResponse(Long claimId, String contactInfo, String rfaiStatus, String rfaiSubmissionDate, String payerName,
			String payerId, String informationReceiver, String responseDate, String billingProvider, String providerNpi, String providerTin,
			String patientLastname, String patientFirstName, String patientIdentifier, String patientcontrolNumber,
			String payerClaimControlNumber, String billType, String clearingHouseId, String medicalRecordNumber) {
		super();
		this.claimId = claimId;
		this.contactInfo = contactInfo;
		this.rfaiStatus = rfaiStatus;
		this.rfaiSubmissionDate = rfaiSubmissionDate;
		this.payerName = payerName;
		this.payerId = payerId;
		this.informationReceiver = informationReceiver;
		this.responseDate = responseDate;
		this.billingProvider = billingProvider;
		this.providerNpi = providerNpi;
		this.providerTin = providerTin;
		this.patientLastname = patientLastname;
		this.patientFirstName = patientFirstName;
		this.patientIdentifier = patientIdentifier;
		this.patientcontrolNumber = patientcontrolNumber;
		this.payerClaimControlNumber = payerClaimControlNumber;
		this.billType = billType;
		this.clearingHouseId = clearingHouseId;
		this.medicalRecordNumber = medicalRecordNumber;
	}
	
	/**
	 * 
	 * @param claimId
	 * @param contactInfo
	 * @param rfaiStatus
	 * @param rfaiSubmissionDate
	 * @param payerName
	 * @param payerId
	 * @param informationReceiver
	 * @param responseDate
	 * @param billingProvider
	 * @param providerNpi
	 * @param providerTin
	 * @param patientLastname
	 * @param patientFirstName
	 * @param patientIdentifier
	 * @param patientcontrolNumber
	 * @param payerClaimControlNumber
	 * @param billType
	 * @param clearingHouseId
	 * @param medicalRecordNumber
	 * @param rfaiRelatedItemResponse
	 * @param statusCode
	 * @param loincCodes
	 * @param loincModCodes
	 */
	public Rfai277SubmissionResponse(Long claimId, String contactInfo, String rfaiStatus, String rfaiSubmissionDate, String payerName,
			String payerId, String informationReceiver, String responseDate, String billingProvider, String providerNpi, String providerTin,
			String patientLastname, String patientFirstName, String patientIdentifier, String patientcontrolNumber,
			String payerClaimControlNumber, String billType, String clearingHouseId, String medicalRecordNumber,
			List<RfaiRelatedItemResponse> rfaiRelatedItemResponse, List<RfaiAttachmentResponse> rfaiAttachmentResponse, 
			List<RfaiLineItemResponse> rfaiLineItemResponse) {
		super();
		this.claimId = claimId;
		this.contactInfo = contactInfo;
		this.rfaiStatus = rfaiStatus;
		this.rfaiSubmissionDate = rfaiSubmissionDate;
		this.payerName = payerName;
		this.payerId = payerId;
		this.informationReceiver = informationReceiver;
		this.responseDate = responseDate;
		this.billingProvider = billingProvider;
		this.providerNpi = providerNpi;
		this.providerTin = providerTin;
		this.patientLastname = patientLastname;
		this.patientFirstName = patientFirstName;
		this.patientIdentifier = patientIdentifier;
		this.patientcontrolNumber = patientcontrolNumber;
		this.payerClaimControlNumber = payerClaimControlNumber;
		this.billType = billType;
		this.clearingHouseId = clearingHouseId;
		this.medicalRecordNumber = medicalRecordNumber;
		this.rfaiRelatedItemResponse = rfaiRelatedItemResponse;
		this.rfaiAttachmentResponse = rfaiAttachmentResponse;
		this.rfaiLineItemResponse = rfaiLineItemResponse;
	}

	public Long getClaimId() {
		return claimId;
	}
	
	

	public String getContactInfo() {
		return contactInfo;
	}

	public void setContactInfo(String contactInfo) {
		this.contactInfo = contactInfo;
	}

	public void setClaimId(Long claimId) {
		this.claimId = claimId;
	}

	public String getRfaiStatus() {
		return rfaiStatus;
	}

	public void setRfaiStatus(String rfaiStatus) {
		this.rfaiStatus = rfaiStatus;
	}

	public String getRfaiSubmissionDate() {
		return rfaiSubmissionDate;
	}

	public void setRfaiSubmissionDate(String rfaiSubmissionDate) {
		this.rfaiSubmissionDate = rfaiSubmissionDate;
	}

	public String getPayerName() {
		return payerName;
	}

	public void setPayerName(String payerName) {
		this.payerName = payerName;
	}

	public String getPayerId() {
		return payerId;
	}

	public void setPayerId(String payerId) {
		this.payerId = payerId;
	}

	public String getInformationReceiver() {
		return informationReceiver;
	}

	public void setInformationReceiver(String informationReceiver) {
		this.informationReceiver = informationReceiver;
	}

	public String getResponseDate() {
		return responseDate;
	}

	public void setResponseDate(String responseDate) {
		this.responseDate = responseDate;
	}

	public String getBillingProvider() {
		return billingProvider;
	}

	public void setBillingProvider(String billingProvider) {
		this.billingProvider = billingProvider;
	}

	public String getProviderNpi() {
		return providerNpi;
	}

	public void setProviderNpi(String providerNpi) {
		this.providerNpi = providerNpi;
	}

	public String getProviderTin() {
		return providerTin;
	}

	public void setProviderTin(String providerTin) {
		this.providerTin = providerTin;
	}

	public String getPatientLastname() {
		return patientLastname;
	}

	public void setPatientLastname(String patientLastname) {
		this.patientLastname = patientLastname;
	}

	public String getPatientFirstName() {
		return patientFirstName;
	}

	public void setPatientFirstName(String patientFirstName) {
		this.patientFirstName = patientFirstName;
	}

	public String getPatientIdentifier() {
		return patientIdentifier;
	}

	public void setPatientIdentifier(String patientIdentifier) {
		this.patientIdentifier = patientIdentifier;
	}

	public String getPatientcontrolNumber() {
		return patientcontrolNumber;
	}

	public void setPatientcontrolNumber(String patientcontrolNumber) {
		this.patientcontrolNumber = patientcontrolNumber;
	}

	public String getPayerClaimControlNumber() {
		return payerClaimControlNumber;
	}

	public void setPayerClaimControlNumber(String payerClaimControlNumber) {
		this.payerClaimControlNumber = payerClaimControlNumber;
	}

	public String getBillType() {
		return billType;
	}

	public void setBillType(String billType) {
		this.billType = billType;
	}

	public String getClearingHouseId() {
		return clearingHouseId;
	}

	public void setClearingHouseId(String clearingHouseId) {
		this.clearingHouseId = clearingHouseId;
	}

	public String getMedicalRecordNumber() {
		return medicalRecordNumber;
	}

	public void setMedicalRecordNumber(String medicalRecordNumber) {
		this.medicalRecordNumber = medicalRecordNumber;
	}

	public List<RfaiRelatedItemResponse> getRfaiRelatedItemResponse() {
		return rfaiRelatedItemResponse;
	}

	public void setRfaiRelatedItemResponse(List<RfaiRelatedItemResponse> rfaiRelatedItemResponse) {
		this.rfaiRelatedItemResponse = rfaiRelatedItemResponse;
	}

	public List<RfaiAttachmentResponse> getRfaiAttachmentResponse() {
		return rfaiAttachmentResponse;
	}

	public void setRfaiAttachmentResponse(List<RfaiAttachmentResponse> rfaiAttachmentResponse) {
		this.rfaiAttachmentResponse = rfaiAttachmentResponse;
	}

	public List<RfaiLineItemResponse> getRfaiLineItemResponse() {
		return rfaiLineItemResponse;
	}

	public void setRfaiLineItemResponse(List<RfaiLineItemResponse> rfaiLineItemResponse) {
		this.rfaiLineItemResponse = rfaiLineItemResponse;
	}
}