package gov.va.med.ars.model.response;

import java.math.BigDecimal;

import java.util.List;


public class AttachmentsStorageResponse {
	
	private BigDecimal totalStorage;
	private BigDecimal availableStorage;
	private BigDecimal totalAttachments;
	private BigDecimal avgAttachSize;
	private BigDecimal usedStorage;
	private BigDecimal peakUsage;
	private BigDecimal average;
	private String fromDate;
	private String toDate;
	private List<BigDecimal> usedStorageStatistic;
	private List<BigDecimal> totalStorageStatistic;
	
	public AttachmentsStorageResponse() {
		super();
	}

	public AttachmentsStorageResponse(BigDecimal totalStorage, BigDecimal availableStorage, BigDecimal totalAttachments,
			BigDecimal avgAttachSize, BigDecimal usedStorage, BigDecimal peakUsage, BigDecimal average, String fromDate,
			String toDate, List<BigDecimal> usedStorageStatistic, List<BigDecimal> totalStorageStatistic) {
		super();
		this.totalStorage = totalStorage;
		this.availableStorage = availableStorage;
		this.totalAttachments = totalAttachments;
		this.avgAttachSize = avgAttachSize;
		this.usedStorage = usedStorage;
		this.peakUsage = peakUsage;
		this.average = average;
		this.fromDate = fromDate;
		this.toDate = toDate;
		this.usedStorageStatistic = usedStorageStatistic;
		this.totalStorageStatistic = totalStorageStatistic;
	}

	public BigDecimal getTotalStorage() {
		return totalStorage;
	}

	public void setTotalStorage(BigDecimal totalStorage) {
		this.totalStorage = totalStorage;
	}

	public BigDecimal getAvailableStorage() {
		return availableStorage;
	}

	public void setAvailableStorage(BigDecimal availableStorage) {
		this.availableStorage = availableStorage;
	}

	public BigDecimal getTotalAttachments() {
		return totalAttachments;
	}

	public void setTotalAttachments(BigDecimal totalAttachments) {
		this.totalAttachments = totalAttachments;
	}

	public BigDecimal getAvgAttachSize() {
		return avgAttachSize;
	}

	public void setAvgAttachSize(BigDecimal avgAttachSize) {
		this.avgAttachSize = avgAttachSize;
	}

	public BigDecimal getUsedStorage() {
		return usedStorage;
	}

	public void setUsedStorage(BigDecimal usedStorage) {
		this.usedStorage = usedStorage;
	}

	public BigDecimal getPeakUsage() {
		return peakUsage;
	}

	public void setPeakUsage(BigDecimal peakUsage) {
		this.peakUsage = peakUsage;
	}

	public BigDecimal getAverage() {
		return average;
	}

	public void setAverage(BigDecimal average) {
		this.average = average;
	}

	public String getFromDate() {
		return fromDate;
	}

	public void setFromDate(String fromDate) {
		this.fromDate = fromDate;
	}

	public String getToDate() {
		return toDate;
	}

	public void setToDate(String toDate) {
		this.toDate = toDate;
	}

	public List<BigDecimal> getUsedStorageStatistic() {
		return usedStorageStatistic;
	}

	public void setUsedStorageStatistic(List<BigDecimal> usedStorageStatistic) {
		this.usedStorageStatistic = usedStorageStatistic;
	}

	public List<BigDecimal> getTotalStorageStatistic() {
		return totalStorageStatistic;
	}

	public void setTotalStorageStatistic(List<BigDecimal> totalStorageStatistic) {
		this.totalStorageStatistic = totalStorageStatistic;
	}

	@Override
	public int hashCode() {
		final int prime = 31;
		int result = 1;
		result = prime * result + ((availableStorage == null) ? 0 : availableStorage.hashCode());
		result = prime * result + ((average == null) ? 0 : average.hashCode());
		result = prime * result + ((avgAttachSize == null) ? 0 : avgAttachSize.hashCode());
		result = prime * result + ((fromDate == null) ? 0 : fromDate.hashCode());
		result = prime * result + ((peakUsage == null) ? 0 : peakUsage.hashCode());
		result = prime * result + ((toDate == null) ? 0 : toDate.hashCode());
		result = prime * result + ((totalAttachments == null) ? 0 : totalAttachments.hashCode());
		result = prime * result + ((totalStorage == null) ? 0 : totalStorage.hashCode());
		result = prime * result + ((totalStorageStatistic == null) ? 0 : totalStorageStatistic.hashCode());
		result = prime * result + ((usedStorage == null) ? 0 : usedStorage.hashCode());
		result = prime * result + ((usedStorageStatistic == null) ? 0 : usedStorageStatistic.hashCode());
		return result;
	}

	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (getClass() != obj.getClass())
			return false;
		AttachmentsStorageResponse other = (AttachmentsStorageResponse) obj;
		if (availableStorage == null) {
			if (other.availableStorage != null)
				return false;
		} else if (!availableStorage.equals(other.availableStorage))
			return false;
		if (average == null) {
			if (other.average != null)
				return false;
		} else if (!average.equals(other.average))
			return false;
		if (avgAttachSize == null) {
			if (other.avgAttachSize != null)
				return false;
		} else if (!avgAttachSize.equals(other.avgAttachSize))
			return false;
		if (fromDate == null) {
			if (other.fromDate != null)
				return false;
		} else if (!fromDate.equals(other.fromDate))
			return false;
		if (peakUsage == null) {
			if (other.peakUsage != null)
				return false;
		} else if (!peakUsage.equals(other.peakUsage))
			return false;
		if (toDate == null) {
			if (other.toDate != null)
				return false;
		} else if (!toDate.equals(other.toDate))
			return false;
		if (totalAttachments == null) {
			if (other.totalAttachments != null)
				return false;
		} else if (!totalAttachments.equals(other.totalAttachments))
			return false;
		if (totalStorage == null) {
			if (other.totalStorage != null)
				return false;
		} else if (!totalStorage.equals(other.totalStorage))
			return false;
		if (totalStorageStatistic == null) {
			if (other.totalStorageStatistic != null)
				return false;
		} else if (!totalStorageStatistic.equals(other.totalStorageStatistic))
			return false;
		if (usedStorage == null) {
			if (other.usedStorage != null)
				return false;
		} else if (!usedStorage.equals(other.usedStorage))
			return false;
		if (usedStorageStatistic == null) {
			if (other.usedStorageStatistic != null)
				return false;
		} else if (!usedStorageStatistic.equals(other.usedStorageStatistic))
			return false;
		return true;
	}

	@Override
	public String toString() {
		return "AttachmentsStorageResponse [totalStorage=" + totalStorage + ", availableStorage=" + availableStorage
				+ ", totalAttachments=" + totalAttachments + ", avgAttachSize=" + avgAttachSize + ", usedStorage="
				+ usedStorage + ", peakUsage=" + peakUsage + ", average=" + average + ", fromDate=" + fromDate
				+ ", toDate=" + toDate + ", usedStorageStatistic=" + usedStorageStatistic + ", totalStorageStatistic="
				+ totalStorageStatistic + "]";
	}
	
	
}
