package gov.va.med.ars.model.request;

import org.springframework.stereotype.Component;

import com.fasterxml.jackson.annotation.JsonInclude;

@Component
public class SearchClaimAttachments275Request {
	private Integer pageSize;
	private String sortColumn;
	private Boolean descending;
	private Integer pageNumber;

	@JsonInclude(JsonInclude.Include.NON_NULL)
	private String attachId;
	@JsonInclude(JsonInclude.Include.NON_NULL)
	private String attachCtrNumber;
	@JsonInclude(JsonInclude.Include.NON_NULL)
	private String claimId;
	@JsonInclude(JsonInclude.Include.NON_NULL)
	private String status;
	@JsonInclude(JsonInclude.Include.NON_NULL)
	private String patientLastName;
	@JsonInclude(JsonInclude.Include.NON_NULL)
	private String patientFirstName;
	@JsonInclude(JsonInclude.Include.NON_NULL)
	private String patientCtrNumber;
	@JsonInclude(JsonInclude.Include.NON_NULL)
	private String patientIdentifier;
	@JsonInclude(JsonInclude.Include.NON_NULL)
	private String providerName;
	@JsonInclude(JsonInclude.Include.NON_NULL)
	private String providerNpi;
	@JsonInclude(JsonInclude.Include.NON_NULL)
	private String medicalRecordNumber;
	@JsonInclude(JsonInclude.Include.NON_NULL)
	private String payerControlNumber;
	@JsonInclude(JsonInclude.Include.NON_NULL)
	private String reportTypeCode;
	@JsonInclude(JsonInclude.Include.NON_NULL)
	private String claimServiceStartDate;
	@JsonInclude(JsonInclude.Include.NON_NULL)
	private String claimServiceEndDate;
	@JsonInclude(JsonInclude.Include.NON_NULL)
	private String attachType;

	public SearchClaimAttachments275Request() {
		super();
	}

	public SearchClaimAttachments275Request(Integer pageSize, String sortColumn, Boolean descending, Integer pageNumber,
			String attachId, String attachCtrNumber, String claimId, String status, String patientLastName,
			String patientFirstName, String patientCtrNumber, String patientIdentifier, String providerName,
			String providerNpi, String medicalRecordNumber, String payerControlNumber, String reportTypeCode,
			String claimServiceStartDate, String claimServiceEndDate,String attachType) {
		super();
		this.pageSize = pageSize;
		this.sortColumn = sortColumn;
		this.descending = descending;
		this.pageNumber = pageNumber;
		this.attachId = attachId;
		this.attachCtrNumber = attachCtrNumber;
		this.claimId = claimId;
		this.status = status;
		this.patientLastName = patientLastName;
		this.patientFirstName = patientFirstName;
		this.patientCtrNumber = patientCtrNumber;
		this.patientIdentifier = patientIdentifier;
		this.providerName = providerName;
		this.providerNpi = providerNpi;
		this.medicalRecordNumber = medicalRecordNumber;
		this.payerControlNumber = payerControlNumber;
		this.reportTypeCode = reportTypeCode;
		this.claimServiceStartDate = claimServiceStartDate;
		this.claimServiceEndDate = claimServiceEndDate;
		this.attachType=attachType;
	}

	public Integer getPageSize() {
		return pageSize;
	}

	public void setPageSize(Integer pageSize) {
		this.pageSize = pageSize;
	}

	public String getSortColumn() {
		return sortColumn;
	}

	public void setSortColumn(String sortColumn) {
		if(sortColumn != null && !sortColumn.isEmpty()) {
			this.sortColumn = sortColumn;
		} else {
			this.sortColumn = "";
		}
	}

	public Boolean getDescending() {
		return descending;
	}

	public void setDescending(Boolean descending) {
		this.descending = descending;
	}

	public Integer getPageNumber() {
		return pageNumber;
	}

	public void setPageNumber(Integer pageNumber) {
		this.pageNumber = pageNumber;
	}

	public String getAttachId() {
		return attachId;
	}

	public void setAttachId(String attachId) {
		this.attachId = attachId;
	}

	public String getAttachCtrNumber() {
		return attachCtrNumber;
	}

	public void setAttachCtrNumber(String attachCtrNumber) {
		this.attachCtrNumber = attachCtrNumber;
	}

	public String getClaimId() {
		return claimId;
	}

	public void setClaimId(String claimId) {
		this.claimId = claimId;
	}

	public String getStatus() {
		return status;
	}

	public void setStatus(String status) {
		this.status = status;
	}

	public String getPatientLastName() {
		return patientLastName;
	}

	public void setPatientLastName(String patientLastName) {
		this.patientLastName = patientLastName;
	}

	public String getPatientFirstName() {
		return patientFirstName;
	}

	public void setPatientFirstName(String patientFirstName) {
		this.patientFirstName = patientFirstName;
	}

	public String getPatientCtrNumber() {
		return patientCtrNumber;
	}

	public void setPatientCtrNumber(String patientCtrNumber) {
		this.patientCtrNumber = patientCtrNumber;
	}

	public String getPatientIdentifier() {
		return patientIdentifier;
	}

	public void setPatientIdentifier(String patientIdentifier) {
		this.patientIdentifier = patientIdentifier;
	}

	public String getProviderName() {
		return providerName;
	}

	public void setProviderName(String providerName) {
		this.providerName = providerName;
	}

	public String getProviderNpi() {
		return providerNpi;
	}

	public void setProviderNpi(String providerNpi) {
		this.providerNpi = providerNpi;
	}

	public String getMedicalRecordNumber() {
		return medicalRecordNumber;
	}

	public void setMedicalRecordNumber(String medicalRecordNumber) {
		this.medicalRecordNumber = medicalRecordNumber;
	}

	public String getPayerControlNumber() {
		return payerControlNumber;
	}

	public void setPayerControlNumber(String payControlNumber) {
		this.payerControlNumber = payControlNumber;
	}

	public String getReportTypeCode() {
		return reportTypeCode;
	}

	public void setReportTypeCode(String reportTypeCode) {
		this.reportTypeCode = reportTypeCode;
	}

	public String getClaimServiceStartDate() {
		return claimServiceStartDate;
	}

	public void setClaimServiceStartDate(String claimServiceStartDate) {
		this.claimServiceStartDate = claimServiceStartDate;
	}

	public String getClaimServiceEndDate() {
		return claimServiceEndDate;
	}

	public void setClaimServiceEndDate(String claimServiceEndDate) {
		this.claimServiceEndDate = claimServiceEndDate;
	}
	
	public String getAttachType() {
		return attachType;
	}

	public void setAttachType(String attachType) {
		this.attachType = attachType;
	}
	
}
