package gov.va.med.ars.dao.fpps;

import java.math.BigDecimal;
import java.util.Set;

import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

import gov.va.med.domain.fee.EwvSlProvider;

@Repository
public interface IEwvSlProviderRepository extends JpaRepository<EwvSlProvider, String> {
	
	@Query("SELECT p from ewvSlProvider p JOIN FETCH p.ewvServiceLines c where c.guid = :guid")
	Set<EwvSlProvider> getEwvSlProviders(@Param("guid") BigDecimal guid);
}