package gov.va.med.ars.dao.fpps;

import java.math.BigDecimal;
import java.util.Set;

import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

import gov.va.med.domain.fee.EwvServiceLines;


@Repository
public interface IEwvServiceLinesRepository extends JpaRepository<EwvServiceLines, String> {
	
	@Query("SELECT s from ewvServiceLines s JOIN FETCH s.ewvClaims c where c.guid = :guid")
	Set<EwvServiceLines> getEwvServiceLines(@Param("guid") BigDecimal guid);
	
	@Query("SELECT s from ewvServiceLines s JOIN FETCH s.ewvClaims c where c.guid = :guid")
	EwvServiceLines getEwvServiceLine(@Param("guid") BigDecimal guid);
}