package gov.va.med.ars.dao.fpps;

import java.math.BigDecimal;
import java.util.Set;

import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

import gov.va.med.domain.fee.EwvServiceLineOhis;;

@Repository
public interface IEwvServiceLineOhisRepository extends JpaRepository<EwvServiceLineOhis, String> {
	
	@Query("SELECT d from ewvServiceLineOhis d JOIN FETCH d.ewvServiceLines s JOIN FETCH s.ewvClaims c where c.guid = :guid")
	Set<EwvServiceLineOhis> getEwvServiceLineOhisByEwvClaim(@Param("guid") BigDecimal guid);
	
	@Query("SELECT d from ewvServiceLineOhis d JOIN FETCH d.ewvServiceLines s where s.guid = :guid")
	Set<EwvServiceLineOhis> getEwvServiceLineOhis(@Param("guid") BigDecimal guid);
}

