package gov.va.med.ars.dao.fpps;

import java.math.BigDecimal;
import java.util.Set;

import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

import gov.va.med.domain.fee.EwvHealthInformation;

@Repository
public interface IEwvHealthInformationRepository extends JpaRepository<EwvHealthInformation, String> {
	
	@Query("SELECT h from ewvHealthInformation h JOIN FETCH h.ewvClaims c where c.guid = :guid")
	Set<EwvHealthInformation> getHealthInformationoByClaimGuid(@Param("guid") BigDecimal guid);
}