package gov.va.med.ars.dao.fpps;

import java.math.BigDecimal;
import java.util.Set;

import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

import gov.va.med.domain.fee.EwvDiagnosisCodes;

@Repository
public interface IEwvDiagnosisCodesRepository extends JpaRepository<EwvDiagnosisCodes, String> {
	
	@Query("SELECT d from ewvDiagnosisCodes d JOIN FETCH d.ewvClaims c where c.guid = :guid")
	Set<EwvDiagnosisCodes> getDiagnosisCodesByClaimGuid(@Param("guid") BigDecimal guid);
}