package gov.va.med.ars.dao.fpps;

import java.math.BigDecimal;

import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

import gov.va.med.domain.fee.EwvClaims;

@Repository
public interface IEwvClaimRepository extends JpaRepository<EwvClaims, String> {
	
	@Query("SELECT p from ewvClaims p where p.pdi = :pdiNumber")
	EwvClaims getEwvClaimByPdiNumber(@Param("pdiNumber") String pdiNumber);
	
	@Query("SELECT c from ewvClaims c JOIN FETCH c.ewvServiceLineses s where s.guid = :guid")
	EwvClaims getEwvClaimByServiceLine(@Param("guid") BigDecimal guid);
}