package gov.va.med.ars.dao.fpps;

import java.math.BigDecimal;
import java.util.Set;

import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

import gov.va.med.domain.fee.EwvClaimLevelAdjustments;;;

@Repository
public interface IEwvClaimLevelAdjustmentsRepository extends JpaRepository<EwvClaimLevelAdjustments, String> {
	
	@Query("SELECT d from ewvClaimLevelAdjustments d JOIN FETCH d.ewvClaimOhis c where c.guid = :guid")
	Set<EwvClaimLevelAdjustments> getEwvClaimLevelAdjustmentsByClaimGuid(@Param("guid") BigDecimal guid);
}