/**
 * 
 */
package gov.va.med.ars.dao.ewv;

import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

import gov.va.med.domain.ewv.EwvClaims;

/**
 * @author PII
 *
 */
@Repository
public interface IRfaiEwvRepository extends JpaRepository<EwvClaims, String> {

	@Query("select p from ewClaims p JOIN FETCH p.ewvServiceLineses e where p.pdi = :pdiNumber")
	EwvClaims getEwvPdiInfo(@Param("pdiNumber") String pdiNumber);
	
	@Query("SELECT CASE WHEN COUNT(c) > 0 THEN 1 ELSE 0 END FROM ewClaims c where c.pdi = :pdiNumber")
	int existsByPDI(@Param("pdiNumber") String pdiNumber);
	
	@Query("SELECT p from ewClaims p where p.ediClaimKey = :ediClaimKey")
	EwvClaims getEwvByEdiClaimKey(@Param("ediClaimKey") String ediClaimKey);
	
	@Query("SELECT p from ewClaims p where p.pdi = :pdiNumber")
	EwvClaims getEwvClaimByPdiNumber(@Param("pdiNumber") String pdiNumber);
}