package gov.va.med.ars.dao.erepos;

import java.util.List;

import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

import gov.va.med.domain.ereposModel.Claim;

/**
 * @author PII
 *
 */
@Repository
public interface IRfaiEreposRepository extends JpaRepository<Claim, String> {

	@Query("select c from eClaim c JOIN FETCH c.entityAdtlIds e JOIN FETCH c.entityNames en where c.claimKey = :claimIndex")
	List<Claim> getEreposClaimInformation(@Param("claimIndex") String claimIndex);
	
	@Query("select clm.receiverId from eClaim clm where clm.claimKey = :claimKey")
	String getReceiverIdByClaimKey(@Param("claimKey") String claimKey);
	
	

}