/**
 * 
 */
package gov.va.med.ars.dao.ars;

import java.util.List;

import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

import gov.va.med.domain.ars.ClaimSubmission;

/**
 * @author PII
 *
 */
@Repository
public interface RfaiLookupRepository extends JpaRepository<ClaimSubmission, Long> {

	List<ClaimSubmission> findBytrn02fppsClaimId(Long long1);
	
	List<ClaimSubmission> findBysubmissionid(Long submissionId);
	
	List<ClaimSubmission> findByhl4nm109ptid(String patientId);
	
	List<ClaimSubmission> findByhl3nm109prvnpi(String providerNpi);
	
	@Query("select p from aclaimSubmission p JOIN FETCH p.hccsCd h JOIN FETCH p.loincCd l JOIN FETCH p.loincModCd m JOIN FETCH p.claimContact t where p.submissionid = :submissionId")
	ClaimSubmission getClaimSubInfo(@Param("submissionId") long submissionId);
	
}
