package gov.va.med.ars.dao.ars;

import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

import gov.va.med.domain.ars.ReferenceIdentification;

@Repository
public interface IReferenceIdentificationRepository extends JpaRepository<ReferenceIdentification, Long> {

	
	@Query("SELECT ri.ref02 FROM areferenceidentification ri where ri.ref01 = 'EA' and ri.attachmentId = :attachmentId")
	String getMedicalRecordNumberByAttachmentId(@Param("attachmentId") Integer attachmentId);
}