
package gov.va.med.ars.dao.ars;

import java.util.List;



import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.CrudRepository;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import gov.va.med.domain.ars.ArsUser;
import gov.va.med.domain.ars.ClaimattachmentsView;

@Transactional
@Repository
public interface IArsUserRepository extends CrudRepository<ArsUser, Long>, JpaSpecificationExecutor<ArsUser> {

	/**
	 * Get ArsUser by UserName
	 * 
	 * @param userName
	 * @return
	 */

	/*
	 * SQL version select * from ars_user a left join ars_user_role_usages b on
	 * a.ars_user_id=b.ars_user_id JOIN ars_Role c on b.ARS_ROLE_ID=
	 * c.ARS_ROLE_ID where a.user_Name = 'PII' and upper(a.enabled) =
	 * 'Y';
	 */
	@Query("SELECT u FROM aarsUser u JOIN FETCH u.arsUserRoleUsageses r JOIN FETCH r.arsRole a WHERE UPPER(u.userName) = UPPER(:username) and upper(u.enabled) = 'Y'")
	List<ArsUser> findByArsUserName(@Param("username") String userName);

	@Query(value = "SELECT UPPER(a.user_name), UPPER(a.last_name), UPPER(a.first_name), UPPER(a.middle_name), UPPER(a.enabled), a.last_login_date, UPPER(a.phone_number), UPPER(a.email_address), UPPER(a.deactivation_comments) "
			+ "FROM aarsUser a WHERE a.app_user_id=:userid", nativeQuery = true)
	ArsUser findByAppUserId(@Param("userid") long userid);

	ArsUser save(ArsUser persisted);

	@Query("select userName from aarsUser")
	List<String> getAllUsers();
	
	ArsUser findByUserNameIgnoreCase(String userName);
	
	ArsUser findByArsUserId(Long usedId);
	
	@Modifying
	@Query("update aarsUser u set u.domain = ?2, u.enableExport = ?3 , u.enableEdit = ?4, u.enableAdmin = ?5 where UPPER(u.userName) = ?1")
	void updateUserByUserName(String userName,String domain,boolean enableExport,boolean enableEdit,boolean enableAdmin);
		
	void delete(ArsUser entity);
}
