package gov.va.med.ars.dao.ars;

import java.math.BigDecimal;

import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

import gov.va.med.ars.model.response.RfaiResponse;
import gov.va.med.domain.ars.ClaimSubmission;
import gov.va.med.domain.ewv.EwvClaims;

@Repository
public interface ClaimSubmissionRepository extends JpaRepository<ClaimSubmission, Long> {

	ClaimSubmission findOne(long claimSubmissionId);
	
	@Query("select p from aclaimSubmission p JOIN FETCH p.claimSvcLineses e where p.submissionid = :submissionId")
	ClaimSubmission getClaimSubInfo(@Param("submissionId") long submissionId);
}