package gov.va.med.ars.dao.ars;

import java.util.Date;
import java.util.List;

import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;
import gov.va.med.domain.ars.ArsAttachmentsStorage;

@Repository
public interface ArsAttachmentsStorageRepository extends JpaRepository<ArsAttachmentsStorage,Long>{
	@Query("SELECT a from aarsAttachmentsStorage a "
			+ "where id IN (select MAX(id) FROM aarsAttachmentsStorage where a.storageDate >= :storageDate "
			+ "GROUP BY to_char(storageDate, 'DDMMYYYY')) order by storageDate")
	List<ArsAttachmentsStorage> getArsAttachmentsStorageInfo(@Param("storageDate") Date dateBeforeSevenDays);

	
	@Query("SELECT a from aarsAttachmentsStorage a "
			+ "where id IN (select MAX(id) FROM aarsAttachmentsStorage WHERE  storageDate between :fromDate AND :toDate "
			+ "GROUP BY to_char(storageDate, 'DDMMYYYY')) order by storageDate")
	List<ArsAttachmentsStorage> getRecords(@Param("fromDate") Date fromDate,@Param("toDate") Date toDate);
	
	@Query("SELECT a from aarsAttachmentsStorage a "
			+ "where id IN (select MAX(id) FROM aarsAttachmentsStorage WHERE  storageDate = :weekBeforeDate"
			+ ")")
	ArsAttachmentsStorage recordBeforeWeek(@Param("weekBeforeDate") Date weekBeforeDate);
}

