package gov.va.med.ars.dao.ars;

import java.util.Date;
import java.util.List;

import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.stereotype.Repository;
import gov.va.med.domain.ars.ArsMetadataStorage;

import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;

@Repository
public interface ARSMetadataStorageRepository extends JpaRepository<ArsMetadataStorage,Long>{

	@Query("SELECT a from ArsMetadataStorage a "
			+ "where id IN (select MAX(id) FROM ArsMetadataStorage WHERE  storageDate between :fromDate AND :toDate "
			+ "GROUP BY to_char(storageDate, 'DDMMYYYY')) order by storageDate")
	List<ArsMetadataStorage> getRecords(@Param("fromDate") Date fromDate,@Param("toDate") Date toDate);
	
	@Query("SELECT a from ArsMetadataStorage a "
			+ "where id IN (select MAX(id) FROM ArsMetadataStorage WHERE  storageDate = :weekBeforeDate"
			+ ")")
	ArsMetadataStorage recordBeforeWeek(@Param("weekBeforeDate") Date weekBeforeDate);
}
