package gov.va.med.ars.controller;

import java.util.ArrayList;
import java.util.List;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

import gov.va.med.ars.exceptions.GenericException;
import gov.va.med.ars.model.response.GenericResponse;
import gov.va.med.ars.model.response.UserDetailsResponse;
import gov.va.med.ars.model.request.UserSearchRequest;
import gov.va.med.ars.service.IUserAdministrationService;
import net.minidev.json.JSONObject;

@RestController
@RequestMapping("/api/v1")
public class UserAdministrationRestController {
	private static final Logger logger = LogManager.getLogger(UserAdministrationRestController.class);
	
	@Autowired
	IUserAdministrationService administartionService;
	
	@RequestMapping(value="/userDetails/{id}",method = RequestMethod.GET, produces = "application/json")
	public ResponseEntity<?> getAllUserDetails(@PathVariable("id") String userId) throws GenericException {
		GenericResponse response=new GenericResponse();
		logger.info("getAllUserDetails : "+"getting users and their for "+userId);
		UserDetailsResponse userdetail=administartionService.getUserById(userId);
		if(userdetail==null){
			logger.info("User not found");
			JSONObject entity = new JSONObject();
			entity.put("response", null);
		//	entity.put("message","Response is null");
			return new ResponseEntity<>(response, HttpStatus.NOT_FOUND);
		}		
		logger.info("User details"+userdetail.toString());
		List<UserDetailsResponse> list=new ArrayList<UserDetailsResponse>();
		list.add(userdetail);
		response.setResponse(list);
		return new ResponseEntity<>(response, HttpStatus.OK);
	}
	
	@PostMapping(value = "/userSearch")
	public ResponseEntity<?> searchAllUsers(@RequestBody UserSearchRequest userSearchRequest){
		JSONObject entity = new JSONObject();
		logger.info("Fetching All Users ");
		
			logger.info("Request is null");
		GenericResponse myResponse = null;		
		try {
			if(userSearchRequest != null) {
				myResponse = administartionService.getAllUserDetails(userSearchRequest);
				if(myResponse!=null)
					logger.info("My response "+myResponse.getResponse().toString());
				else{
					logger.info("The response is null");
					entity.put("errorCode", "No Record Found");
					entity.put("message","Response is null");
					return new ResponseEntity<>(entity, HttpStatus.NOT_FOUND);	
				}	
			} else {
				logger.info("The userSearchRequest is null");
				entity.put("errorCode", "Un-Authorized");
				entity.put("message","Enter a valid userinformation");
				return new ResponseEntity<>(entity, HttpStatus.NOT_FOUND);
			}
			
		} catch (GenericException e) {			
			logger.error(
					"searchAllUsers() exception occured " + e.getMessage());				
			entity.put("errorCode", "Error in Server");
			entity.put("message","Server Error");
			return new ResponseEntity<JSONObject>(entity, HttpStatus.INTERNAL_SERVER_ERROR);
		}			
		return new ResponseEntity<GenericResponse>(myResponse, HttpStatus.OK);		
	}
	
	@PostMapping(value = "/editUser")
	public ResponseEntity<JSONObject> editUser(@RequestBody UserSearchRequest userSearchRequest){
		JSONObject entity = new JSONObject();
		try {
			if(userSearchRequest != null) {
				administartionService.editUserByUserName(userSearchRequest);
			} else {
				logger.info("The userSearchRequest is null");
				entity.put("errorCode", "Un-Authorized");
				entity.put("message","Enter a valid userinformation");
				return new ResponseEntity<>(entity, HttpStatus.NOT_FOUND);
			}
		} catch (GenericException e) {			
			logger.error(
					"editUser() exception occured " + e.getMessage());			
			entity.put("errorCode", "Error in editing user");
			entity.put("message","Server Error");
			return new ResponseEntity<JSONObject>(entity, HttpStatus.INTERNAL_SERVER_ERROR);
		}
		entity.put("success", "true");
		return new ResponseEntity<JSONObject>(entity, HttpStatus.OK);	
	}
	
	@RequestMapping(value="/userDelete/{id}",method = RequestMethod.GET, produces = "application/json")
	public ResponseEntity<JSONObject> deleteUser(@PathVariable("id") Long userId) {
		logger.info("Hitting the delete service");
		JSONObject entity = new JSONObject();
		try {
			if(userId != null) {
				administartionService.deleteUserByUserName(userId);
				entity.put("success", "true");
				return new ResponseEntity<JSONObject>(entity, HttpStatus.OK);	
			} else {
				logger.info("The userSearchRequest is null");
				entity.put("errorCode", "Un-Authorized");
				entity.put("message","Enter a valid userinformation");
				return new ResponseEntity<>(entity, HttpStatus.NOT_FOUND);
			}
		} catch (GenericException e) {
			entity.put("errorCode", "Error in deleting user");
			entity.put("message","Server Error");
			return new ResponseEntity<JSONObject>(entity, HttpStatus.INTERNAL_SERVER_ERROR);
		}
	}
}
