package gov.va.med.ars.controller;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import gov.va.med.ars.service.IUserAdminService;
import javafx.util.Pair;
import gov.va.med.ars.exceptions.GenericException;
import gov.va.med.ars.model.request.UserSearchRequest;
import net.minidev.json.JSONObject;

@RestController
@RequestMapping("/api/v1/admin")
public class UserAdminController {
	private static final Logger logger = LogManager.getLogger(UserAdminController.class);
	
	@Autowired
	private IUserAdminService userAdminService;
	
	@SuppressWarnings("restriction")
	@PostMapping("/createUser")
	public ResponseEntity<JSONObject> createUser(@RequestBody UserSearchRequest request)
			throws GenericException {
		//boolean isSuccess = false;
		Pair <String,Boolean> resultPair;
		JSONObject entity = new JSONObject();
		try {
			resultPair = userAdminService.createUser(request);
			
			if(resultPair.getValue()) {
				entity.put("success", "Create User Success");
			} else {
				entity.put("errorCode","Error in creating user");
				entity.put("message", resultPair.getKey());
			}
			
		} catch (GenericException e) {			
			logger.debug("Unable to Create User" + e);
			entity.put("errorCode","Error in creating user");
			entity.put("message","Please try again");
			return new ResponseEntity<>(entity, HttpStatus.CREATED);
			//throw e;
		}
		return new ResponseEntity<>(entity, HttpStatus.CREATED);
	}
}