/**
 * 
 */
package gov.va.med.ars.controller;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import gov.va.med.ars.constants.ErrorMessages;
import gov.va.med.ars.exceptions.GenericException;
import gov.va.med.ars.model.request.RfaiLookupRequest;
import gov.va.med.ars.model.request.UpdateRfaiRequest;
import gov.va.med.ars.model.response.GenericResponse;
import gov.va.med.ars.service.IRfaiLookupService;
import gov.va.med.ars.service.IUpdateRfaiService;
import net.minidev.json.JSONObject;

/**
 * @author PII
 *
 */
@RestController
@RequestMapping("api/v1/updateRfai")
public class UpdateRfaiController {

	private static final Logger logger = LogManager.getLogger(UpdateRfaiController.class);

	@Autowired
	IUpdateRfaiService updateService;

	/**
	 * @throws Exception 
	 * 
	 */
	@PostMapping(value = "/submitSimpleUpdate")
	public ResponseEntity<?> postSubmitSimpleUpdate(@RequestBody UpdateRfaiRequest updateRfaiRequest)
			throws Exception {

		if (updateRfaiRequest == null || updateRfaiRequest.getSubmissionId() == null
				|| updateRfaiRequest.getSubmissionStatus() == null
				|| updateRfaiRequest.getSubmissionStatus().trim().isEmpty()
				|| updateRfaiRequest.getResponseDate() == null
				|| updateRfaiRequest.getResponseDate().trim().isEmpty()) {

			throw new GenericException(ErrorMessages.INVALID_REQUEST, "Invalid request", HttpStatus.NOT_FOUND);
		}

		try {

			boolean updateResult = updateService.submitSimpleUpdate(updateRfaiRequest);

			if (updateResult) {

				JSONObject jsonResponse = new JSONObject();
				jsonResponse.put("result", true);

				ResponseEntity<?> response = new ResponseEntity<>(jsonResponse, HttpStatus.OK);
				logger.info(
						String.format("Successfully updated RFAI submission %s", updateRfaiRequest.getSubmissionId()));

				return response;

			} else {
				return new ResponseEntity<>(
						String.format("Error in updating RFAI Submission %s", updateRfaiRequest.getSubmissionId()),
						HttpStatus.BAD_REQUEST);
			}

		} catch (Exception e) {
			logger.error("UpdateRfaiController:postSubmitSimpleUpdate() exception occured " + e.getMessage());
			throw e;
		}
	}
}
