package gov.va.med.ars.controller;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import gov.va.med.ars.exceptions.EntityNotFoundException;
import gov.va.med.ars.exceptions.GenericException;
import gov.va.med.ars.exceptions.ValidationException;
import gov.va.med.ars.model.request.Unmatched837Request;
import gov.va.med.ars.service.IUnmatched837AttachmentService;
import gov.va.med.ars.validators.NumberValidator;
import net.minidev.json.JSONObject;

@RestController
@RequestMapping("api/v1/unmatched837")
public class Unmatched837AttachmentController extends NumberValidator {

	private static final Logger logger = LogManager.getLogger(Unmatched837AttachmentController.class);

	@Autowired
	IUnmatched837AttachmentService unmatched837AttachmentService;

	@PostMapping("/match")
	public ResponseEntity<?> matchClaimAttachment(@RequestBody Unmatched837Request request)
			throws ValidationException, GenericException, EntityNotFoundException {
		try {
			JSONObject response = new JSONObject();

			if (request != null) {
				if (!isValidNumber(request.getUnmatched837Id())) {
					response.put("errorCode", "Invalid Request");
					response.put("message", "Please enter in a valid Claim ID or PDI.");
					return new ResponseEntity<>(response, HttpStatus.BAD_REQUEST);
				} else {
					logger.info("Unmatched837AttachmentController: valid request for match on pdi/claim id"
							+ request.getUnmatched837Id());
					boolean unmatchedResponse = unmatched837AttachmentService.matchClaimAttachment(request);

					if (unmatchedResponse) {
						response.put("response", unmatchedResponse);
						return new ResponseEntity<>(response, HttpStatus.OK);
					} else {
						response.put("errorCode", "Invalid Request");
						response.put("message", "No PDI/Claim Id found for: " + request.getUnmatched837Id());
						return new ResponseEntity<>(response, HttpStatus.BAD_REQUEST);
					}

				}
			} else {
				response = new JSONObject();
				response.put("errorCode", "Invalid Request");
				response.put("message", "Please enter in a valid Data.");
				return new ResponseEntity<>(response, HttpStatus.BAD_REQUEST);
			}
		} catch (GenericException e) {
			logger.error("matchClaimAttachments() exception occured " + e.getMessage());
			throw e;
		}
	}
}