package gov.va.med.ars.controller;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import gov.va.med.ars.exceptions.GenericException;
import gov.va.med.ars.model.request.SearchClaimAttachments275Request;
import gov.va.med.ars.model.response.GenericResponse;
import gov.va.med.ars.service.ISearchClaimAttachments275Service;

@RestController
@RequestMapping("api/v1/searchClaimAttachments275")
public class SearchClaimAttachments275Controller {

	private static final Logger logger = LogManager.getLogger(SearchClaimAttachments275Controller.class);

	@Autowired
	ISearchClaimAttachments275Service searchClaimAttachments275Service;

	@PostMapping(value = "/search")
	public ResponseEntity<?> searchClaimAttachments(
			@RequestBody SearchClaimAttachments275Request searchClaimAttachments275Request) throws GenericException {
		try {
			logger.info("searching 275");
			if (searchClaimAttachments275Request == null)
				logger.info("Request is null");
			GenericResponse myResponse = searchClaimAttachments275Service
					.getAll275SearchResult(searchClaimAttachments275Request);
			if (myResponse != null)
				logger.info("My response " + myResponse.getpageNumber());
			else {
				logger.info("The response is null");
				return new ResponseEntity<>(null, HttpStatus.SERVICE_UNAVAILABLE);
			}

			return new ResponseEntity<>(myResponse, HttpStatus.OK);

		} catch (Exception e) {
			logger.error("searchClaimAttachments() exception occured " + e.getMessage());
			throw e;
		}
	}

}
