/**
 * 
 */
package gov.va.med.ars.controller;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import gov.va.med.ars.exceptions.EntityNotFoundException;
import gov.va.med.ars.exceptions.GenericException;
import gov.va.med.ars.exceptions.ValidationException;
import gov.va.med.ars.model.response.RfaiResponse;
import gov.va.med.ars.service.IRfaiService;
import gov.va.med.ars.validators.NumberValidator;
import net.minidev.json.JSONObject;

/**
 * @author PII
 *
 */
@RestController
@RequestMapping("api/v1/populateClaim")
public class RfaiController extends NumberValidator {

	private static final Logger logger = LogManager.getLogger(RfaiController.class);

	@Autowired
	IRfaiService rfaiService;

	@GetMapping("/{id}")
	public ResponseEntity<?> getClaim(@PathVariable("id") String id)
			throws ValidationException, GenericException, EntityNotFoundException {
		JSONObject response = null;
		//Boolean isValid;
		try {
			if(id != null && !id.isEmpty()) {
				if (isValidNumber(id) != null) {
					logger.info("RfaiController:getClaim() received the request for claim Number :" + Long.valueOf(id));

					logger.debug("RfaiController:getClaim() invoking the rfaiService.populateRfaiInfo() for claim index"
							+ Long.valueOf(id));
					RfaiResponse rfaiResponse = rfaiService.populateRfaiInfo(Long.valueOf(id));
					if (rfaiResponse == null) {
						return new ResponseEntity<>("No Claim found for ID " + id, HttpStatus.NOT_FOUND);
					}
					return new ResponseEntity<>(rfaiResponse, HttpStatus.OK);
				} else {
					return new ResponseEntity<>("No Claim found for ID " + id, HttpStatus.NOT_FOUND);
				}
			} else {
				response = new JSONObject();
				logger.warn("getClaim : no Claim Number passed for  "+id);
				response.put("errorCode", "Un-Authorized");
				response.put("message", "The entered user has no populate claims in the application since the claim Number is empty");
				return new ResponseEntity<>(response,HttpStatus.NOT_FOUND);
			}
			
		} catch (GenericException e) {
			logger.error(
					"RfaiController:getClaim() exception occured for claim index : " + id + " - " + e.getMessage());
			throw e;
		}
	}
}
