package gov.va.med.ars.controller;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import gov.va.med.ars.exceptions.GenericException;
import gov.va.med.ars.model.response.Rfai277SubmissionResponse;
import gov.va.med.ars.service.IRfai277SubmissionService;

@RestController
@RequestMapping("api/v1/submission")
public class Rfai277SubmissionController {
	
	private static final Logger logger = LogManager.getLogger(Rfai277SubmissionController.class);
	
	@Autowired
	IRfai277SubmissionService rfaiSubmissionService;
	
	@GetMapping("/{id}")
	public ResponseEntity<?> getSubmissionById(@PathVariable("id") long id) throws GenericException {
		
		try { 
			Rfai277SubmissionResponse rfaiSubResponse = rfaiSubmissionService.getRfaiSubmissionResults(id);
			
			if(rfaiSubResponse == null) {
				return new ResponseEntity<>("No Claim found for Submission ID " + id, HttpStatus.NOT_FOUND);

			} else 
				return new ResponseEntity<>(rfaiSubResponse, HttpStatus.OK);
			
		} catch(Exception e) {
			logger.error(
					"RfaiSubmissionController:getSubmissionById() exception occured " + e.getMessage());
			throw e;
		}
	}	
}