package gov.va.med.ars.controller;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import gov.va.med.ars.exceptions.GenericException;
import gov.va.med.ars.model.request.SearchReportRequest;
import gov.va.med.ars.model.response.GenericResponse;
import gov.va.med.ars.service.IReportService;
import gov.va.med.ars.validators.NumberValidator;
import net.minidev.json.JSONObject;

@RestController
@RequestMapping("api/v1/reports")
public class ReportController extends NumberValidator {

	private static final Logger logger = LogManager.getLogger(ReportController.class);

	@Autowired
	IReportService reportService;

	@PostMapping(value = "/search")
	public ResponseEntity<?> searchReports(@RequestBody SearchReportRequest searchReportRequest,
			@RequestParam(value = "matched", required = true) boolean getMatchedReport) throws GenericException {
		JSONObject response = null;
		try {
			if(searchReportRequest != null) {
				if (!isValidNumber(searchReportRequest.getPayerId())) {
					response = new JSONObject();
					response.put("errorCode", "Invalid Request");
					response.put("message", "Please enter in a valid Payer ID.");
					return new ResponseEntity<>(response, HttpStatus.BAD_REQUEST);

				} else {
					GenericResponse searchResponse = reportService.getReports(searchReportRequest, getMatchedReport);
					return new ResponseEntity<>(searchResponse, HttpStatus.OK);
				}
			} else {
				response = new JSONObject();
				response.put("errorCode", "Invalid Request");
				response.put("message", "Please enter in a valid Data.");
				return new ResponseEntity<>(response, HttpStatus.BAD_REQUEST);
			}
			

		} catch (Exception e) {
			logger.error("ReportController.searchReports() exception occured " + e.getMessage());
			throw e;
		}
	}
}
