package gov.va.med.ars.controller;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;


import gov.va.med.ars.model.response.RfaiResponse;
import gov.va.med.ars.service.IAdditionalInfoRequestService;
import net.minidev.json.JSONObject;
import gov.va.med.ars.exceptions.GenericException;


@RestController
public class RFAI277RequestSubmitController {
	
	private static final Logger log = LogManager.getLogger(RFAI277RequestSubmitController.class);
	
	@Autowired
	IAdditionalInfoRequestService additionalInfoRequestService;
	
	@PostMapping(value = "/api/v1/additionalInfoRequest")
	public ResponseEntity<?> submitRfaiRequest(@RequestBody RfaiResponse request) throws GenericException {
		ResponseEntity<?> response = null;

		Long claimId = request.getClaimId();

		if (claimId == null || claimId == 0) {
			throw new GenericException("Error", "Missing ClaimId", HttpStatus.BAD_REQUEST);
		}
		
		if (request.getClaimStatus() == null) {
			throw new GenericException("Error", "Missing ClaimStatus", HttpStatus.BAD_REQUEST);
		}

		try {

			boolean result = additionalInfoRequestService.submitAdditionalInfoRequest(request);

			if (result) {
				JSONObject jsonResponse = new JSONObject();
				jsonResponse.put("result", true);

				response = new ResponseEntity<>(jsonResponse, HttpStatus.CREATED);
				log.info("Successfully submitted additional information request to ARS Database : "
						+ request.toString());

			} else {
				return new ResponseEntity<>("Error in creating", HttpStatus.BAD_REQUEST);
			}
		} catch (GenericException e) {
			log.error("There was an error in submitting additional information request, please contact support.");
			throw e;
		}
		return response;
	}
}