package gov.va.med.ars.controller;

import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

import gov.va.med.ars.model.response.GenericResponse;
import gov.va.med.ars.model.response.MetaDataResponse;
import gov.va.med.ars.service.IDashboardService;
import net.minidev.json.JSONObject;

@RestController
@RequestMapping("/api/v1/dashboard/")
public class DashboardController {

	private static final Logger logger=LogManager.getLogger(DashboardController.class);
	
	@Autowired
	IDashboardService dashboardService;
	
	@RequestMapping(value="/metaDataDetails",method = RequestMethod.GET, produces = "application/json")
	public ResponseEntity<?> getMetadataStorageInfo(){
		logger.info("Getting the Meta Data Details");
		JSONObject entity = new JSONObject();
		MetaDataResponse response=dashboardService.getMetaDataDetails();
		if(response == null ){
			entity.put("errorCode", "No Record Found");
			entity.put("message","Response is null");
			return new ResponseEntity<>(null, HttpStatus.NOT_FOUND);
		}
		return new ResponseEntity<>(response, HttpStatus.OK);
	}
	
	@RequestMapping(value="/attachmentDetails",method = RequestMethod.GET, produces = "application/json")
	public ResponseEntity<?> getAttachmentStorageInfo(){
		logger.info("Getting the Attachment Data Details");
		JSONObject entity = new JSONObject();
		MetaDataResponse response=dashboardService.getAttachmentsDetails();
		if(response == null ){
			entity.put("errorCode", "No Record Found");
			entity.put("message","Response is null");
			return new ResponseEntity<>(null, HttpStatus.NOT_FOUND);
		}
		return new ResponseEntity<>(response, HttpStatus.OK);
	}
}
