/**
 * 
 */
package gov.va.med.ars.controller;

import java.util.List;

import javax.servlet.http.HttpServletRequest;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

import gov.va.med.ars.exceptions.GenericException;
import gov.va.med.ars.model.request.GenericRequest;
import gov.va.med.ars.service.ICodeAndModifierService;
import net.minidev.json.JSONObject;

/**
 * @author PII
 *
 */
@RestController
@RequestMapping("api/v1/populate")
public class CodeAndModifiersController {

	private static final Logger logger = LogManager.getLogger(CodeAndModifiersController.class);

	@Autowired
	ICodeAndModifierService codeAndModiferService;

	/**
	 * 
	 */
	@PostMapping(value = { "/loinc", "/loincMod", "/hccs" })
	public ResponseEntity<?> getCodes(@RequestBody List<String> codesToProcess, HttpServletRequest request)
			throws GenericException {
		String currentUrl = request.getRequestURI().toString();
		try {
			List<?> response = codeAndModiferService.getCodeAndModifier(currentUrl, codesToProcess);
			return new ResponseEntity<>(response, HttpStatus.OK);
		} catch (Exception e) {
			logger.error("PopulateCodeAndModifiersController:getCodes() exception occured for claim index : "
					+ e.getMessage());
			throw e;
		}
	}

	@RequestMapping(value = { "/add" }, method = { RequestMethod.POST, RequestMethod.PUT })
	public ResponseEntity<?> addOrModifyCodes(@RequestBody GenericRequest codeAndModifierRequest,
			HttpServletRequest request) throws GenericException {
		JSONObject jsonResponse = null;
		try {
			if(codeAndModifierRequest != null) {
				List<String> duplicateCheck = codeAndModiferService
						.checkSubmittedModificationsForDupes(codeAndModifierRequest);
				if (!duplicateCheck.isEmpty()) {
					logger.warn("Found Duplicates in Request");
					JSONObject entity = new JSONObject();
					entity.put("errorCode", "Update Codes Not Complete: Duplicates Found");
					entity.put("message", duplicateCheck);
					return new ResponseEntity<>(entity, HttpStatus.BAD_REQUEST);
				}
				boolean response = codeAndModiferService.addOrModifyCodeAndModifier(codeAndModifierRequest);
				JSONObject entity = new JSONObject();
				entity.put("result", response);
				return new ResponseEntity<>(entity, HttpStatus.OK);
			} else {
				jsonResponse = new JSONObject();
				logger.warn("getClaim : no information was passed");
				jsonResponse.put("errorCode", "Un-Authorized");
				jsonResponse.put("message", "The entered user has no access to the add the codes");
				return new ResponseEntity<>(jsonResponse,HttpStatus.NOT_FOUND);
			}
			
		} catch (Exception e) {
			logger.error("PopulateCodeAndModifiersController:getCodes() exception occured for claim index : "
					+ e.getMessage());
			throw e;
		}
	}

}
